/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.QueryTemplateFactory;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.validation.Validator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatingRepository
implements RepositoryService {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingRepository.class);
    private final RepositoryService repository;
    private final Validator validator;

    public ValidatingRepository(RepositoryService repository, Validator validator) {
        this.repository = repository;
        this.validator = validator;
    }

    public boolean exists(String id) {
        return this.repository.exists(id);
    }

    public <T extends ConfigurationItem> T read(String id) {
        return (T)this.repository.read(id);
    }

    public <T extends ConfigurationItem> T read(String id, int depth) {
        return (T)this.repository.read(id, depth);
    }

    public <T extends ConfigurationItem> T read(String id, WorkDir workDir) {
        return (T)this.repository.read(id, workDir);
    }

    public <T extends ConfigurationItem> T read(String id, boolean useCache) {
        return (T)this.repository.read(id, useCache);
    }

    public <T extends ConfigurationItem> T read(String id, WorkDir workDir, boolean useCache) {
        return (T)this.repository.read(id, workDir, useCache);
    }

    public <T extends ConfigurationItem> T read(String id, int depth, WorkDir workDir, boolean useCache) {
        return (T)this.repository.read(id, depth, workDir, useCache);
    }

    public List<ConfigurationItemData> list(SearchParameters criteria) {
        return this.repository.list(criteria);
    }

    public List<ConfigurationItemData> list(QueryTemplate queryTemplate) {
        return this.repository.list(queryTemplate);
    }

    public <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters) {
        return this.repository.listEntities(parameters);
    }

    public <T extends ConfigurationItem> List<T> listEntities(QueryTemplate queryTemplate) {
        return this.repository.listEntities(queryTemplate);
    }

    public <T extends ConfigurationItem> void create(T ... entity) {
        this.validate((ConfigurationItem[])entity);
        this.repository.create(entity);
    }

    public <T extends ConfigurationItem> void update(T ... entity) {
        this.validate((ConfigurationItem[])entity);
        this.repository.update(entity);
    }

    public <T extends ConfigurationItem> void createOrUpdate(T ... entity) {
        this.validate((ConfigurationItem[])entity);
        this.repository.createOrUpdate(entity);
    }

    public <T extends ConfigurationItem> void move(String id, String newId) {
        this.repository.move(id, newId);
    }

    public <T extends ConfigurationItem> void copy(String id, String newId) {
        this.repository.copy(id, newId);
    }

    public void rename(String id, String newName) {
        this.repository.rename(id, newName);
    }

    public void delete(String ... id) {
        this.repository.delete(id);
    }

    public void execute(ChangeSet changeset) {
        this.repository.execute(changeset);
    }

    public void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException {
        this.repository.checkReferentialIntegrity(changeset);
    }

    public QueryTemplateFactory getQueryTemplateFactory() {
        return this.repository.getQueryTemplateFactory();
    }

    private <T extends ConfigurationItem> void validate(T[] entity) {
        for (T ci : entity) {
            try {
                this.validator.validateCi(ci);
            }
            catch (Validator.ValidationsFailedException vfe) {
                this.printErrors(vfe);
                throw vfe;
            }
        }
    }

    private void printErrors(Validator.ValidationsFailedException vfe) {
        if (vfe.getEntity() instanceof ConfigurationItem) {
            ConfigurationItem entity = (ConfigurationItem)vfe.getEntity();
            LOG.error("Validation failed: {}", (Object)entity.get$validationMessages());
        }
    }
}

