/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize.exceptionmappers;

import com.xebialabs.xltest.serialize.exceptionmappers.AbstractExceptionMapper;
import com.xebialabs.xltype.serialization.SerializationException;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class SerializationExceptionMapper
extends AbstractExceptionMapper
implements ExceptionMapper<SerializationException> {
    private static final Logger LOG = LoggerFactory.getLogger(SerializationExceptionMapper.class);

    public Response toResponse(SerializationException exception) {
        Map<String, Object> response = this.getBaseResponse();
        String message = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
        response.put("message", "Not all information has been filled in correctly.");
        response.put("tech_message", message);
        response.put("status", 422);
        response.put("error_code", "illegal.argument");
        return Response.status((int)422).type("application/json").entity(response).build();
    }
}

