/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import java.util.List;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.delete.IndexDeleteRequest;
import org.elasticsearch.action.delete.IndexDeleteResponse;
import org.elasticsearch.action.delete.ShardDeleteRequest;
import org.elasticsearch.action.delete.ShardDeleteResponse;
import org.elasticsearch.action.delete.TransportShardDeleteAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.TransportIndexReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportIndexDeleteAction
extends TransportIndexReplicationOperationAction<IndexDeleteRequest, IndexDeleteResponse, ShardDeleteRequest, ShardDeleteRequest, ShardDeleteResponse> {
    private static final String ACTION_NAME = "indices:data/write/delete[index]";

    @Inject
    public TransportIndexDeleteAction(Settings settings, ClusterService clusterService, ThreadPool threadPool, TransportShardDeleteAction deleteAction, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, clusterService, threadPool, deleteAction, actionFilters);
    }

    @Override
    protected IndexDeleteResponse newResponseInstance(IndexDeleteRequest request, List<ShardDeleteResponse> shardDeleteResponses, int failuresCount, List<ShardOperationFailedException> shardFailures) {
        return new IndexDeleteResponse(request.index(), failuresCount, shardDeleteResponses.toArray(new ShardDeleteResponse[shardDeleteResponses.size()]));
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    @Override
    protected GroupShardsIterator shards(IndexDeleteRequest request) {
        return this.clusterService.operationRouting().broadcastDeleteShards(this.clusterService.state(), request.index());
    }

    @Override
    protected ShardDeleteRequest newShardRequestInstance(IndexDeleteRequest request, int shardId) {
        return new ShardDeleteRequest(request, shardId);
    }
}

