/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.DocumentConstants;
import org.modeshape.jcr.cache.document.DocumentStore;

public class DocumentOptimizer
implements DocumentConstants {
    private final SchematicDb storeDb;
    private final DocumentStore documentStore;

    public DocumentOptimizer(DocumentStore documentStore) {
        this.documentStore = documentStore;
        this.storeDb = null;
        assert (this.storeDb != null || this.documentStore != null);
    }

    public DocumentOptimizer(Cache<String, SchematicEntry> cache) {
        this.documentStore = null;
        this.storeDb = Schematic.get(cache);
        assert (this.storeDb != null || this.documentStore != null);
    }

    public boolean optimizeChildrenBlocks(NodeKey key, EditableDocument document, int targetCountPerBlock, int tolerance) {
        if (document == null && (document = this.edit(key.toString())) == null) {
            return false;
        }
        EditableArray children = document.getArray("children");
        if (children == null) {
            return false;
        }
        EditableDocument info = document.getDocument("childrenInfo");
        boolean selfContained = true;
        if (info != null) {
            selfContained = !info.containsField("nextBlock");
        }
        boolean changed = false;
        if (selfContained) {
            int total = children.size();
            if (total < targetCountPerBlock + tolerance) {
                return false;
            }
            this.splitChildren(key, document, children, targetCountPerBlock, tolerance, true, null);
            changed = true;
        } else {
            assert (info != null);
            EditableDocument doc = document;
            NodeKey docKey = key;
            while (doc != null) {
                boolean isFirst;
                EditableDocument docInfo = doc.getDocument("childrenInfo");
                String nextKey = docInfo != null ? docInfo.getString("nextBlock") : null;
                children = doc.getArray("children");
                int count = children.size();
                boolean bl = isFirst = doc == document;
                if (count > targetCountPerBlock + tolerance) {
                    this.splitChildren(docKey, doc, children, targetCountPerBlock, tolerance, isFirst, nextKey);
                    changed = true;
                } else if (count < targetCountPerBlock - tolerance && nextKey != null) {
                    nextKey = this.mergeChildren(docKey, doc, children, isFirst, nextKey);
                    changed = true;
                    if (nextKey == null) {
                        info.setString("lastBlock", docKey.toString());
                    }
                }
                if (nextKey != null) {
                    doc = this.edit(nextKey);
                    docKey = new NodeKey(nextKey);
                    continue;
                }
                doc = null;
            }
        }
        return changed;
    }

    protected EditableDocument edit(String key) {
        if (this.documentStore != null) {
            return this.documentStore.edit(key, false);
        }
        if (this.storeDb != null) {
            return this.storeDb.editContent(key, false);
        }
        return null;
    }

    protected boolean splitChildren(NodeKey key, EditableDocument document, EditableArray children, int targetCountPerBlock, int tolerance, boolean isFirst, String nextBlock) {
        String firstNewBlockKey;
        assert (0 < targetCountPerBlock);
        assert (0 < tolerance);
        assert (tolerance < targetCountPerBlock);
        int total = children.size();
        int numFullBlocks = total / targetCountPerBlock;
        if (numFullBlocks == 0) {
            return false;
        }
        int sizeOfLastBlock = total % targetCountPerBlock;
        if (sizeOfLastBlock < targetCountPerBlock - tolerance) {
            if (numFullBlocks == 1) {
                return false;
            }
            sizeOfLastBlock = 0;
        }
        int startIndex = targetCountPerBlock;
        int endIndex = 0;
        String blockKey = firstNewBlockKey = key.withRandomId().toString();
        for (int n = 1; n != numFullBlocks; ++n) {
            String nextBlockKey;
            boolean isLast = n == numFullBlocks - 1;
            endIndex = isLast ? total : startIndex + targetCountPerBlock;
            EditableArray blockChildren = Schematic.newArray((Collection)children.subList(startIndex, endIndex));
            nextBlockKey = isLast ? (nextBlockKey = nextBlock) : key.withRandomId().toString();
            EditableDocument blockDoc = Schematic.newDocument();
            EditableDocument childInfo = blockDoc.setDocument("childrenInfo");
            childInfo.setNumber("blockSize", blockChildren.size());
            if (nextBlockKey != null) {
                childInfo.setString("nextBlock", nextBlockKey);
            }
            blockDoc.setArray("children", (Array)blockChildren);
            this.documentStore.localStore().put(blockKey, (Document)blockDoc);
            if (isLast) continue;
            blockKey = nextBlockKey;
            startIndex = endIndex;
        }
        EditableArray newChildren = Schematic.newArray((Collection)children.subList(0, targetCountPerBlock));
        document.setArray("children", (Array)newChildren);
        EditableDocument childInfo = document.getDocument("childrenInfo");
        if (childInfo == null) {
            childInfo = document.setDocument("childrenInfo");
        }
        childInfo.setNumber("blockSize", newChildren.size());
        childInfo.setString("nextBlock", firstNewBlockKey);
        if (isFirst && nextBlock == null) {
            childInfo.setString("lastBlock", blockKey);
        }
        return true;
    }

    protected String mergeChildren(NodeKey key, EditableDocument document, EditableArray children, boolean isFirst, String nextBlock) {
        EditableDocument info = document.getDocument("childrenInfo");
        if (info == null) {
            info = document.setDocument("childrenInfo");
        }
        HashSet<String> toBeDeleted = new HashSet<String>();
        SchematicEntry nextEntry = null;
        String nextBlocksNext = null;
        while (nextBlock != null) {
            nextEntry = this.documentStore.get(nextBlock);
            Document nextDoc = nextEntry.getContent();
            List nextChildren = nextDoc.getArray("children");
            Document nextInfo = nextDoc.getDocument("childrenInfo");
            if (nextChildren == null || nextChildren.isEmpty()) {
                toBeDeleted.add(nextBlock);
                nextEntry = null;
                nextBlock = nextInfo != null ? nextInfo.getString("nextBlock") : null;
                continue;
            }
            children.addAll((Collection)nextChildren);
            String string = nextBlocksNext = nextInfo != null ? nextInfo.getString("nextBlock") : null;
            if (isFirst && nextBlocksNext == null) {
                info.setNumber("count", children.size());
                info.remove("nextBlock");
                info.remove("lastBlock");
            } else {
                info.setNumber("blockSize", children.size());
                info.setString("nextBlock", nextBlocksNext);
            }
            toBeDeleted.add(nextBlock);
            nextBlock = null;
        }
        for (String deleteKey : toBeDeleted) {
            this.documentStore.remove(deleteKey);
        }
        return nextBlocksNext;
    }
}

