/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import java.io.Closeable;
import java.util.Timer;
import java.util.TimerTask;

public class DefaultExecutionOutputHandler
implements OverthereExecutionOutputHandler,
Closeable {
    public static final int FLUSH_DELAY_MS = 5000;
    public static final int FLUSH_CHECK_INTERVAL_MS = 2000;
    private static final Timer flushTimer = new Timer("AutoFlushTimer", true);
    private ExecutionContext context;
    private boolean stdout;
    private StringBuilder lineBuffer;
    private long flushAfter;
    private TimerTask flushTimerTask;

    DefaultExecutionOutputHandler(ExecutionContext context, boolean stdout) {
        this.context = context;
        this.stdout = stdout;
        this.lineBuffer = new StringBuilder();
        this.flushAfter = DefaultExecutionOutputHandler.nextFlushTime();
        this.flushTimerTask = new TimerTask(){

            @Override
            public void run() {
                DefaultExecutionOutputHandler.this.checkFlushNeeded();
            }
        };
        flushTimer.schedule(this.flushTimerTask, 5000L, 2000L);
    }

    private static long nextFlushTime() {
        return System.currentTimeMillis() + 5000L;
    }

    private synchronized void checkFlushNeeded() {
        if (this.flushAfter < System.currentTimeMillis()) {
            this.flushLineBuffer();
        }
    }

    public final void handleLine(String line) {
    }

    public final void handleChar(char c) {
        if (c != '\r' && c != '\n') {
            this.appendToLineBuffer(c);
        }
        if (c == '\n') {
            this.flushLineBuffer();
        }
    }

    private synchronized void appendToLineBuffer(char c) {
        this.lineBuffer.append(c);
    }

    private synchronized void flushLineBuffer() {
        if (this.lineBuffer.length() > 0) {
            this.flushLine(this.lineBuffer.toString());
            this.lineBuffer.setLength(0);
        }
        this.flushAfter = DefaultExecutionOutputHandler.nextFlushTime();
    }

    private void flushLine(String buffer) {
        if (this.stdout) {
            this.context.logOutput(buffer);
        } else {
            this.context.logError(buffer);
        }
    }

    @Override
    public synchronized void close() {
        this.flushTimerTask.cancel();
    }

    public static DefaultExecutionOutputHandler handleStdout(ExecutionContext context) {
        return new DefaultExecutionOutputHandler(context, true);
    }

    public static DefaultExecutionOutputHandler handleStderr(ExecutionContext context) {
        return new DefaultExecutionOutputHandler(context, false);
    }
}

