/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.dto.ArtifactAndData;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.spi.command.CopyCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCiCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCisCommand;
import com.xebialabs.deployit.engine.spi.command.MoveCiCommand;
import com.xebialabs.deployit.engine.spi.command.RenameCiCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.util.TFiles;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlplatform.artifact.ArtifactEnricher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.QueryParam;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ThrowingRuntimeExceptionHandlerStrategy;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class RepositoryResource
extends AbstractSecuredResource
implements com.xebialabs.deployit.engine.api.RepositoryService {
    public static final Predicate<String> canRead = new Predicate<String>(){

        public boolean apply(String input) {
            return PlatformPermissions.READ.getPermissionHandler().hasPermission(input);
        }
    };
    public static final Predicate<ConfigurationItemData> hasReadRight = new Predicate<ConfigurationItemData>(){

        public boolean apply(ConfigurationItemData input) {
            return PlatformPermissions.READ.getPermissionHandler().hasPermission(input.getId());
        }
    };
    public static final Predicate<ConfigurationItem> canEdit = new Predicate<ConfigurationItem>(){

        public boolean apply(ConfigurationItem input) {
            return PlatformPermissions.EDIT_REPO.getPermissionHandler().hasPermission(input.getId());
        }
    };
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private Validator validator;
    @Autowired
    private RoleService roleService;
    @Autowired
    private WorkDirFactory workDirFactory;
    @Value(value="#{serverConfiguration.uploadFileBufferSize}")
    private Integer uploadFileBufferSize;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryResource.class);

    public ConfigurationItem read(String id) {
        this.checkPermission(PlatformPermissions.READ, id);
        return this.repositoryService.read(id, 1);
    }

    public List<ConfigurationItem> read(List<String> ids) {
        ArrayList result = Lists.newArrayList();
        Collection datas = Collections2.filter(ids, canRead);
        for (String data : datas) {
            try {
                ConfigurationItem entity = this.repositoryService.read(data, 1);
                result.add(entity);
            }
            catch (RuntimeException re) {
                logger.error("Could not read configuration item [{}]", (Object)data);
                logger.error("Exception was: ", (Throwable)re);
            }
        }
        return result;
    }

    public List<ConfigurationItemId> query(Type type, String parent, String ancestor, String namePattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage) {
        return this.list(SearchParametersFactory.createSearchParams(type, page, resultPerPage, parent, ancestor, namePattern, lastModifiedBefore != null ? lastModifiedBefore.toGregorianCalendar() : null, 0));
    }

    public List<ConfigurationItemId> candidateValues(@QueryParam(value="propertyName") String propertyName, @QueryParam(value="namePattern") String namePattern, @QueryParam(value="page") long page, @QueryParam(value="resultsPerPage") long resultPerPage, ConfigurationItem ci) {
        return this.list(SearchParametersFactory.createSearchParamsForCandidateValues(propertyName, namePattern, page, resultPerPage, ci));
    }

    private List<ConfigurationItemId> list(SearchParameters searchParams) {
        FluentIterable filtered = FluentIterable.from((Iterable)this.repositoryService.list(searchParams)).filter(hasReadRight).transform(DtoReader.ciDataToCiId);
        return Lists.newArrayList((Iterable)filtered);
    }

    public ConfigurationItem create(String id, ConfigurationItem ci) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.createInternal(ci, null);
    }

    @Workdir(prefix="artifact")
    public ConfigurationItem create(final String id, final ArtifactAndData aad) {
        return WorkDirTemplate.cleanOnFinally(new WorkDirTemplate.Callback<ConfigurationItem>(){

            @Override
            public ConfigurationItem doWithWorkdir(WorkDir workDir) {
                RepositoryResource.this.checkPermission(PlatformPermissions.EDIT_REPO, id);
                Artifact artifact = aad.getArtifact();
                Checks.checkArgument((boolean)id.equals(artifact.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{artifact.getId(), id});
                artifact.setFile((OverthereFile)RepositoryResource.this.readArtifactData(aad, workDir));
                if (artifact instanceof FolderArtifact) {
                    Checks.checkTrue((boolean)TFiles.isArchive((String)artifact.getFile().getPath()), (String)"Folder artifact [%s] is not a valid ZIP archive", (Object[])new Object[]{artifact.getFile().getName()});
                }
                return RepositoryResource.this.createInternal((ConfigurationItem)artifact, workDir);
            }
        });
    }

    private ConfigurationItem createInternal(ConfigurationItem ci, WorkDir workDir) {
        if (ci instanceof SourceArtifact) {
            final SourceArtifact artifact = (SourceArtifact)ci;
            boolean hasFileUri = StringUtils.isNotBlank((String)artifact.getFileUri());
            boolean hasUploadedFile = artifact.getFile() != null;
            Checks.checkTrue((hasFileUri || hasUploadedFile ? 1 : 0) != 0, (String)"Artifacts need to have either a %s set or an uploaded file", (Object[])new Object[]{"fileUri"});
            Checks.checkTrue((!hasFileUri || !hasUploadedFile ? 1 : 0) != 0, (String)"Artifacts must not have both a %s set and an uploaded file", (Object[])new Object[]{"fileUri"});
            if (workDir == null) {
                workDir = this.workDirFactory.newWorkDir("external");
                WorkDirTemplate.cleanOnFinally(workDir, new WorkDirTemplate.Callback<Object>(){

                    @Override
                    public Object doWithWorkdir(WorkDir workDir) {
                        new ArtifactEnricher((Artifact)artifact, workDir).enrich();
                        return null;
                    }
                });
            } else {
                new ArtifactEnricher((Artifact)artifact, workDir).enrich();
            }
        }
        this.validator.validateCi(ci);
        ArrayList ids = Lists.newArrayList();
        this.checkReadAccessOnRelations(null, ci, ids);
        if (!ids.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + ids);
        }
        Set<ConfigurationItem> ciSet = new CiCollector(Collections.singletonList(ci)).collect();
        this.publishCommand((RepositoryBaseCommand)new CreateCisCommand((List)Lists.newArrayList(ciSet)));
        return this.repositoryService.read(ci.getId(), 1);
    }

    private <T> T getOrNull(ConfigurationItem ci, PropertyDescriptor pd) {
        if (ci == null) {
            return null;
        }
        return (T)pd.get(ci);
    }

    private void checkReadAccessOnRelations(ConfigurationItem existingCi, ConfigurationItem updatedCi, List<String> nonReadIdAggregator) {
        Collection propertyDescriptors = updatedCi.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.isAsContainment()) continue;
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: 
                case DATE: 
                case SET_OF_STRING: 
                case LIST_OF_STRING: 
                case MAP_STRING_STRING: {
                    break;
                }
                case CI: {
                    ConfigurationItem linkedCi = (ConfigurationItem)propertyDescriptor.get(updatedCi);
                    if (linkedCi == null) break;
                    String id = linkedCi.getId();
                    ConfigurationItem existingLinkedCi = (ConfigurationItem)this.getOrNull(existingCi, propertyDescriptor);
                    if (existingLinkedCi != null && existingLinkedCi.getId().equals(id) || this.hasPermission(PlatformPermissions.READ, id)) break;
                    nonReadIdAggregator.add(id);
                    break;
                }
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    Collection cis = (Collection)propertyDescriptor.get(updatedCi);
                    Collection existingCis = (Collection)this.getOrNull(existingCi, propertyDescriptor);
                    ArrayList existingLinkedCiIds = existingCis == null ? Lists.newArrayList() : FluentIterable.from((Iterable)existingCis).transform((Function)new Function<ConfigurationItem, String>(){

                        public String apply(ConfigurationItem input) {
                            return input.getId();
                        }
                    }).toList();
                    for (ConfigurationItem configurationItem : cis) {
                        if (configurationItem == null || existingLinkedCiIds.contains(configurationItem.getId()) || this.hasPermission(PlatformPermissions.READ, configurationItem.getId())) continue;
                        nonReadIdAggregator.add(configurationItem.getId());
                    }
                    break;
                }
            }
        }
    }

    public List<ConfigurationItem> create(List<ConfigurationItem> cis) {
        List ciIds = Lists.transform(cis, (Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem from) {
                return from.getId();
            }
        });
        for (String s : ciIds) {
            this.checkPermission(PlatformPermissions.EDIT_REPO, s);
        }
        this.validator.validateCis(cis);
        ArrayList ids = Lists.newArrayList();
        for (ConfigurationItem ci : cis) {
            this.checkReadAccessOnRelations(null, ci, ids);
        }
        if (!ids.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + ids);
        }
        Set<ConfigurationItem> ciSet = new CiCollector(cis).collect();
        CreateCisCommand event = new CreateCisCommand((List)Lists.newArrayList(ciSet));
        this.publishCommand((RepositoryBaseCommand)event);
        return this.reloadEntityAndCreateSuccessResponse(cis);
    }

    public ConfigurationItem update(String id, ConfigurationItem ci) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.updateInternal(ci);
    }

    @Workdir(prefix="artifact")
    public ConfigurationItem update(final String id, final ArtifactAndData aad) {
        return WorkDirTemplate.cleanOnFinally(new WorkDirTemplate.Callback<ConfigurationItem>(){

            @Override
            public ConfigurationItem doWithWorkdir(WorkDir workDir) {
                RepositoryResource.this.checkPermission(PlatformPermissions.EDIT_REPO, id);
                Checks.checkArgument((boolean)id.equals(aad.getArtifact().getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{aad.getArtifact().getId(), id});
                aad.getArtifact().setFile((OverthereFile)RepositoryResource.this.readArtifactData(aad, workDir));
                return RepositoryResource.this.updateInternal((ConfigurationItem)aad.getArtifact());
            }
        });
    }

    private ConfigurationItem updateInternal(ConfigurationItem ci) {
        this.validator.validateCi(ci);
        ConfigurationItem previous = this.repositoryService.read(ci.getId(), false);
        ArrayList ids = Lists.newArrayList();
        this.checkReadAccessOnRelations(previous, ci, ids);
        if (!ids.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + ids);
        }
        this.publishCommand((RepositoryBaseCommand)new UpdateCiCommand(previous, ci));
        return this.repositoryService.read(ci.getId(), 1);
    }

    public List<ConfigurationItem> update(List<ConfigurationItem> cis) {
        Collection filter = Collections2.filter(cis, canEdit);
        ArrayList updates = Lists.newArrayList();
        ArrayList aggregator = Lists.newArrayList();
        for (ConfigurationItem configurationItem : filter) {
            if (this.repositoryService.exists(configurationItem.getId())) {
                ConfigurationItem previous = this.repositoryService.read(configurationItem.getId(), 1, null, false);
                this.checkReadAccessOnRelations(previous, configurationItem, aggregator);
                updates.add(new Update(previous, configurationItem));
                continue;
            }
            this.checkReadAccessOnRelations(null, configurationItem, aggregator);
            updates.add(new Update(null, configurationItem));
        }
        if (!aggregator.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + aggregator);
        }
        UpdateCisCommand command = new UpdateCisCommand((List)updates);
        this.publishCommand((RepositoryBaseCommand)command);
        return this.reloadEntityAndCreateSuccessResponse(filter);
    }

    public ConfigurationItem move(String id, String targetId) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.checkPermission(PlatformPermissions.EDIT_REPO, targetId);
        Splitter splitter = Splitter.on((String)"/");
        Checks.checkArgument((boolean)this.getFirst(splitter.split((CharSequence)id)).equals(this.getFirst(splitter.split((CharSequence)targetId))), (String)"Cannot move ci [%s] to [%s] because that is outside of the root where it is stored.", (Object[])new Object[]{id, targetId});
        this.publishCommand((RepositoryBaseCommand)new MoveCiCommand(id, targetId));
        return this.read(targetId);
    }

    public ConfigurationItem copy(String id, String targetId) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.checkPermission(PlatformPermissions.EDIT_REPO, targetId);
        Splitter splitter = Splitter.on((String)"/");
        Checks.checkArgument((boolean)this.getFirst(splitter.split((CharSequence)id)).equals(this.getFirst(splitter.split((CharSequence)targetId))), (String)"Cannot move ci [%s] to [%s] because that is outside of the root where it is stored.", (Object[])new Object[]{id, targetId});
        this.publishCommand((RepositoryBaseCommand)new CopyCiCommand(id, targetId, this.read(id).getType()));
        return this.read(targetId);
    }

    private String getFirst(Iterable<String> iterable) {
        return iterable.iterator().next();
    }

    public ConfigurationItem rename(String id, String targetName) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.publishCommand((RepositoryBaseCommand)new RenameCiCommand(id, targetName, this.read(id).getType()));
        String targetId = id.substring(0, id.lastIndexOf(47) + 1) + targetName;
        return this.read(targetId);
    }

    public List<ConfigurationItem> validate(List<ConfigurationItem> cis) {
        this.validator.validateCis(cis);
        return cis;
    }

    public void delete(String id) {
        this.checkDeletePermission(id);
        this.publishCommand((RepositoryBaseCommand)new DeleteCiCommand(id));
    }

    public void deleteList(List<String> ids) {
        this.publishCommand((RepositoryBaseCommand)new DeleteCisCommand(ids));
    }

    protected void checkDeletePermission(String id) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
    }

    public Boolean exists(String id) {
        return this.repositoryService.exists(id);
    }

    private List<ConfigurationItem> reloadEntityAndCreateSuccessResponse(Collection<ConfigurationItem> cis) {
        ArrayList reloaded = Lists.newArrayList();
        for (ConfigurationItem ci : cis) {
            ConfigurationItem reloadedCi = this.repositoryService.read(ci.getId(), 1);
            reloaded.add(reloadedCi);
        }
        return reloaded;
    }

    private LocalFile readArtifactData(ArtifactAndData aad, WorkDir workDir) {
        Checks.checkArgument((aad.getFilename() != null ? 1 : 0) != 0, (String)"The filename for the artifact should not be null", (Object[])new Object[0]);
        LocalFile localFile = workDir.newFile(aad.getFilename());
        try (OutputStream outputStream = localFile.getOutputStream();
             InputStream inputStream = aad.getDataInputStream();){
            this.copy(inputStream, outputStream);
        }
        catch (IOException e) {
            throw new DeployitException("Could not write Artifact data for [" + aad.getArtifact().getId() + "] to [" + localFile + "]");
        }
        return localFile;
    }

    private void publishCommand(RepositoryBaseCommand event) {
        List roles = this.roleService.listMyRoles();
        event.setSecurityContext(Permissions.getAuthenticatedUserName(), roles);
        EventBusHolder.publish((Object)event, (EventHandlerStrategy)new ThrowingRuntimeExceptionHandlerStrategy());
    }

    private void copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[this.uploadFileBufferSize.intValue()];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }

    static class CiCollector {
        private Collection<? extends ConfigurationItem> cis;

        public CiCollector(Collection<? extends ConfigurationItem> cis) {
            this.cis = cis;
        }

        public Set<ConfigurationItem> collect() {
            HashSet collector = Sets.newHashSet();
            this.collectNestedCis(this.cis, collector);
            return collector;
        }

        private Set<ConfigurationItem> collectNestedCis(Collection<? extends ConfigurationItem> cis, Set<ConfigurationItem> collector) {
            for (ConfigurationItem configurationItem : cis) {
                collector.add(configurationItem);
                for (PropertyDescriptor property : configurationItem.getType().getDescriptor().getPropertyDescriptors()) {
                    PropertyKind kind = property.getKind();
                    if (kind != PropertyKind.SET_OF_CI && kind != PropertyKind.LIST_OF_CI) continue;
                    Collection<ConfigurationItem> children = this.getChildren(configurationItem, property);
                    this.collectNestedCis(children, collector);
                }
            }
            return collector;
        }

        private Collection<ConfigurationItem> getChildren(ConfigurationItem parent, PropertyDescriptor property) {
            Collection references = (Collection)property.get(parent);
            if (property.isAsContainment()) {
                return references;
            }
            ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
            for (ConfigurationItem ci : references) {
                if (!this.isChild(ci, parent)) continue;
                children.add(ci);
            }
            return children;
        }

        private boolean isChild(ConfigurationItem ci, ConfigurationItem parent) {
            for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
                PropertyKind kind = property.getKind();
                if (kind != PropertyKind.CI || !parent.equals(property.get(ci))) continue;
                return true;
            }
            return false;
        }
    }
}

