/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.CandidateValuesFilter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.SearchParameters;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Set;
import nl.javadude.scannit.Scannit;

public class SearchParametersFactory {
    static final long DEFAULT_RESULTS_PER_PAGE = 25L;

    public static SearchParameters createSearchParams(Type type, long page, long resultPerPage) {
        SearchParameters searchParams = new SearchParameters();
        if (type != null) {
            searchParams.setType(type);
        }
        searchParams.setPage(page);
        if (resultPerPage > 0L) {
            searchParams.setResultsPerPage(resultPerPage);
        } else if (resultPerPage == 0L) {
            searchParams.setResultsPerPage(25L);
        }
        return searchParams;
    }

    public static SearchParameters createSearchParams(Type typeName, long page, long resultPerPage, String parent, String ancestor, String id, Calendar lastModifiedBefore, int depth) {
        SearchParameters searchParams = SearchParametersFactory.createSearchParams(typeName, page, resultPerPage);
        if (Strings.isNotBlank((String)parent)) {
            searchParams.setParent(parent);
        }
        if (Strings.isNotBlank((String)ancestor)) {
            searchParams.setAncestor(ancestor);
        }
        if (Strings.isNotBlank((String)id)) {
            searchParams.setName(id);
        }
        searchParams.setBefore(lastModifiedBefore);
        searchParams.setDepth(depth);
        return searchParams;
    }

    @Deprecated
    public static SearchParameters createSearchParams(Type typeName, long page, long resultPerPage, String parent, String id, Calendar lastModifiedBefore, int depth) {
        return SearchParametersFactory.createSearchParams(typeName, page, resultPerPage, parent, null, id, lastModifiedBefore, depth);
    }

    public static SearchParameters createSearchParamsForCandidateValues(String propertyName, String namePattern, long page, long resultPerPage, ConfigurationItem ci) {
        SearchParameters params;
        final PropertyDescriptor pd = ci.getType().getDescriptor().getPropertyDescriptor(propertyName);
        Preconditions.checkNotNull((Object)pd, (String)"Property %s does not exist on type %s", (Object[])new Object[]{propertyName, ci.getType().getName()});
        Preconditions.checkArgument((boolean)EnumSet.of(PropertyKind.CI, PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(pd.getKind()), (String)"Property %s of type %s is not of kind CI, LIST_OF_CI or SET_OF_CI", (Object[])new Object[]{propertyName, ci.getType().getName()});
        Set filterMethods = Scannit.getInstance().getMethodsAnnotatedWith(CandidateValuesFilter.class);
        Optional filterMethod = Iterables.tryFind((Iterable)filterMethods, (Predicate)new Predicate<Method>(){

            public boolean apply(Method input) {
                return input.getAnnotation(CandidateValuesFilter.class).name().equals(pd.getCandidateValuesFilter());
            }
        });
        if (filterMethod.isPresent()) {
            try {
                com.xebialabs.deployit.plugin.api.services.SearchParameters apiParams = (com.xebialabs.deployit.plugin.api.services.SearchParameters)((Method)filterMethod.get()).invoke(null, ci, pd);
                params = new SearchParameters(apiParams);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(String.format("Could not access filter method [%s]", pd.getCandidateValuesFilter()), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(String.format("Could not invoke filter method [%s]", pd.getCandidateValuesFilter()), e);
            }
        } else {
            params = new SearchParameters();
            params.setType(pd.getReferencedType());
        }
        params.setName(namePattern);
        params.setPage(page);
        params.setResultsPerPage(resultPerPage);
        return params;
    }
}

