/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.core.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class ApacheHttpClient4Engine
implements ClientHttpEngine {
    private static final Logger logger = Logger.getLogger(ApacheHttpClient4Engine.class);
    private static String processId = null;
    protected HttpClient httpClient;
    protected boolean createdHttpClient;
    protected HttpContext httpContext;
    protected boolean closed;
    protected SSLContext sslContext;
    protected HostnameVerifier hostnameVerifier;
    protected int fileUploadInMemoryThresholdLimit = 1;
    protected MemoryUnit fileUploadMemoryUnit = MemoryUnit.MB;
    protected File fileUploadTempFileDir = new File(System.getProperty("java.io.tmpdir"));

    public ApacheHttpClient4Engine() {
        this.httpClient = new DefaultHttpClient();
        this.createdHttpClient = true;
    }

    public ApacheHttpClient4Engine(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ApacheHttpClient4Engine(HttpClient httpClient, boolean closeHttpClient) {
        this.httpClient = httpClient;
        this.createdHttpClient = closeHttpClient;
    }

    public ApacheHttpClient4Engine(HttpClient httpClient, HttpContext httpContext) {
        this.httpClient = httpClient;
        this.httpContext = httpContext;
    }

    public int getFileUploadInMemoryThresholdLimit() {
        return this.fileUploadInMemoryThresholdLimit;
    }

    public void setFileUploadInMemoryThresholdLimit(int fileUploadInMemoryThresholdLimit) {
        this.fileUploadInMemoryThresholdLimit = fileUploadInMemoryThresholdLimit;
    }

    public MemoryUnit getFileUploadMemoryUnit() {
        return this.fileUploadMemoryUnit;
    }

    public void setFileUploadMemoryUnit(MemoryUnit fileUploadMemoryUnit) {
        this.fileUploadMemoryUnit = fileUploadMemoryUnit;
    }

    public File getFileUploadTempFileDir() {
        return this.fileUploadTempFileDir;
    }

    public void setFileUploadTempFileDir(File fileUploadTempFileDir) {
        this.fileUploadTempFileDir = fileUploadTempFileDir;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpResponse response) {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        for (Header header : response.getAllHeaders()) {
            headers.add(header.getName(), (Object)header.getValue());
        }
        return headers;
    }

    @Override
    public ClientResponse invoke(ClientInvocation request) {
        HttpResponse res;
        String uri = request.getUri().toString();
        HttpRequestBase httpMethod = this.createHttpMethod(uri, request.getMethod());
        try {
            this.loadHttpMethod(request, httpMethod);
            res = this.httpClient.execute((HttpUriRequest)httpMethod, this.httpContext);
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to invoke request", (Throwable)e);
        }
        finally {
            this.cleanUpAfterExecute(httpMethod);
        }
        ClientResponse response = new ClientResponse(request.getClientConfiguration()){
            InputStream stream;
            InputStream hc4Stream;

            @Override
            protected void setInputStream(InputStream is) {
                this.stream = is;
            }

            @Override
            public InputStream getInputStream() {
                if (this.stream == null) {
                    HttpEntity entity = res.getEntity();
                    if (entity == null) {
                        return null;
                    }
                    try {
                        this.hc4Stream = entity.getContent();
                        this.stream = new SelfExpandingBufferredInputStream(this.hc4Stream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.stream;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseConnection() throws IOException {
                try {
                    if (this.stream != null) {
                        this.stream.close();
                    } else {
                        InputStream is = this.getInputStream();
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                finally {
                    if (this.hc4Stream != null) {
                        try {
                            this.hc4Stream.close();
                        }
                        catch (IOException ignored) {}
                    } else {
                        try {
                            HttpEntity entity = res.getEntity();
                            if (entity != null) {
                                entity.getContent().close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        response.setProperties(request.getMutableProperties());
        response.setStatus(res.getStatusLine().getStatusCode());
        response.setHeaders((MultivaluedMap<String, String>)ApacheHttpClient4Engine.extractHeaders(res));
        response.setClientConfiguration(request.getClientConfiguration());
        return response;
    }

    protected HttpRequestBase createHttpMethod(String url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new HttpGet(url);
        }
        if ("POST".equals(restVerb)) {
            return new HttpPost(url);
        }
        final String verb = restVerb;
        return new HttpPost(url){

            public String getMethod() {
                return verb;
            }
        };
    }

    protected void loadHttpMethod(ClientInvocation request, HttpRequestBase httpMethod) throws Exception {
        if (httpMethod instanceof HttpGet) {
            // empty if block
        }
        HttpClientParams.setRedirecting((HttpParams)httpMethod.getParams(), (boolean)false);
        if (request.getEntity() != null) {
            if (httpMethod instanceof HttpGet) {
                throw new ProcessingException("A GET request cannot have a body.");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.getDelegatingOutputStream().setDelegate((OutputStream)baos);
            try {
                HttpEntity entity = this.buildEntity(request);
                HttpPost post = (HttpPost)httpMethod;
                this.commitHeaders(request, httpMethod);
                post.setEntity(entity);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.commitHeaders(request, httpMethod);
        }
    }

    protected void commitHeaders(ClientInvocation request, HttpRequestBase httpMethod) {
        MultivaluedMap<String, String> headers = request.getHeaders().asMap();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                httpMethod.addHeader((String)header.getKey(), value);
            }
        }
    }

    @Override
    public void close() {
        ClientConnectionManager manager;
        if (this.closed) {
            return;
        }
        if (this.createdHttpClient && this.httpClient != null && (manager = this.httpClient.getConnectionManager()) != null) {
            manager.shutdown();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected void cleanUpAfterExecute(HttpRequestBase httpMethod) {
        HttpPost postMethod;
        HttpEntity entity;
        if (httpMethod != null && httpMethod instanceof HttpPost && (entity = (postMethod = (HttpPost)httpMethod).getEntity()) != null && entity instanceof FileExposingFileEntity) {
            File tempRequestFile = ((FileExposingFileEntity)entity).getFile();
            try {
                boolean isDeleted = tempRequestFile.delete();
                if (!isDeleted) {
                    this.handleFileNotDeletedError(tempRequestFile, null);
                }
            }
            catch (Exception ex) {
                this.handleFileNotDeletedError(tempRequestFile, ex);
            }
        }
    }

    protected HttpEntity buildEntity(ClientInvocation request) throws IOException {
        FileExposingFileEntity entityToBuild = null;
        DeferredFileOutputStream memoryManagedOutStream = this.writeRequestBodyToOutputStream(request);
        if (memoryManagedOutStream.isInMemory()) {
            ByteArrayEntity entityToBuildByteArray = new ByteArrayEntity(memoryManagedOutStream.getData());
            entityToBuildByteArray.setContentType((Header)new BasicHeader("Content-Type", request.getHeaders().getMediaType().toString()));
            entityToBuild = entityToBuildByteArray;
        } else {
            File requestBodyFile = memoryManagedOutStream.getFile();
            requestBodyFile.deleteOnExit();
            entityToBuild = new FileExposingFileEntity(memoryManagedOutStream.getFile(), request.getHeaders().getMediaType().toString());
        }
        return entityToBuild;
    }

    private DeferredFileOutputStream writeRequestBodyToOutputStream(ClientInvocation request) throws IOException {
        DeferredFileOutputStream memoryManagedOutStream = new DeferredFileOutputStream(this.fileUploadInMemoryThresholdLimit * this.getMemoryUnitMultiplier(), this.getTempfilePrefix(), ".tmp", this.fileUploadTempFileDir);
        request.getDelegatingOutputStream().setDelegate((OutputStream)memoryManagedOutStream);
        request.writeRequestBody(request.getEntityStream());
        memoryManagedOutStream.close();
        return memoryManagedOutStream;
    }

    protected String getTempfilePrefix() {
        return processId;
    }

    private int getMemoryUnitMultiplier() {
        switch (this.fileUploadMemoryUnit) {
            case BY: {
                return 1;
            }
            case KB: {
                return 1024;
            }
            case MB: {
                return 0x100000;
            }
            case GB: {
                return 0x40000000;
            }
        }
        return 1;
    }

    private void handleFileNotDeletedError(File tempRequestFile, Exception ex) {
        logger.warn("Could not delete file' " + tempRequestFile.getAbsolutePath() + "' for request: ", (Throwable)ex);
    }

    static {
        processId = ManagementFactory.getRuntimeMXBean().getName().replaceAll("[^0-9a-zA-Z]", "");
    }

    private static class FileExposingFileEntity
    extends FileEntity {
        public FileExposingFileEntity(File pFile, String pContentType) {
            super(pFile, pContentType);
        }

        File getFile() {
            return this.file;
        }
    }

    public static enum MemoryUnit {
        BY,
        KB,
        MB,
        GB;

    }
}

