/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.gatling;

import java.util.Arrays;

public class Line {
    private String[] parts;
    private String simulationName;

    static Line parseLine(String strLine) {
        Line line = new Line();
        line.parts = strLine.split("\\t");
        return line;
    }

    public boolean isRunLine() {
        return this.getParts()[2].equals("RUN");
    }

    public boolean isRequestLine() {
        return this.getParts()[2].equals("REQUEST");
    }

    public boolean isStartLine() {
        return this.getParts()[3].equals("START");
    }

    public boolean isEndLine() {
        return this.getParts()[3].equals("END");
    }

    public String getUserId() {
        String part = this.getParts()[1];
        return part.substring(part.lastIndexOf(45), part.length());
    }

    public String getRequestDescription() {
        StringBuilder sb = new StringBuilder();
        for (int i = 3; i < this.getParts().length - 8; ++i) {
            sb.append(this.getParts()[i]);
            sb.append(" ");
        }
        return sb.toString();
    }

    public long getStartTime() {
        if (this.isStartLine() || this.isEndLine()) {
            return Long.parseLong(this.getParts()[4]);
        }
        if (this.isRunLine()) {
            return Long.parseLong(this.getParts()[3]);
        }
        throw new RuntimeException("You can't derive the start time from a non START, END, or RUN line: " + Arrays.toString(this.getParts()));
    }

    public long getEndTime() {
        if (this.isEndLine()) {
            return Long.parseLong(this.getParts()[5]);
        }
        throw new RuntimeException("You can't derive the end time from a non END line: " + Arrays.toString(this.getParts()));
    }

    public String getStatus() {
        if (this.isRequestLine()) {
            return this.getParts()[this.getParts().length - 1];
        }
        throw new RuntimeException("You can't derive the status from a non REQUEST line: " + Arrays.toString(this.getParts()));
    }

    public String[] getParts() {
        return this.parts;
    }

    public void setParts(String[] parts) {
        this.parts = parts;
    }

    public String getSimulationName() {
        if (this.isRunLine()) {
            return this.getParts()[1];
        }
        throw new IllegalAccessError("Simulation name can only be retrieved from first line of the log");
    }
}

