/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.InvalidProductException;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseCiCounter;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.service.LicenseTransaction;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLicenseService
implements LicenseService {
    protected static final Logger log = LoggerFactory.getLogger(AbstractLicenseService.class);
    protected final File licenseFile;
    protected final String product;
    private String minimumLicenseVersion;
    protected License license;
    protected LicenseCiCounter ciCounter;
    protected RepositoryService repositoryService;

    public AbstractLicenseService(String licensePath, String product, String minimumLicenseVersion) throws IOException {
        this.product = product;
        this.minimumLicenseVersion = minimumLicenseVersion;
        this.licenseFile = new File(licensePath);
    }

    @Override
    public void initialize(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        this.reLoadCiCounter();
    }

    protected void logLicenseError(File licenseFile) {
        log.warn("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
        log.warn("*** Place a valid license in {} to continue using the product.", (Object)licenseFile.getAbsolutePath());
    }

    protected void logLicenseVersionError(License license, String minimumLicenseVersion) {
        log.error("*** Your license has version {}, however you need a minimum version of {}", (Object)license.getLicenseVersion(), (Object)minimumLicenseVersion);
        log.error("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
    }

    protected void reLoadCiCounter() {
        log.debug("Loading License CI counter using current license.");
        this.ciCounter = LicenseCiCounter.readFrom(this.license, this.repositoryService);
        log.debug("License CI counter loaded and contains {} allowed CI amounts.", (Object)this.ciCounter.allowedCiAmounts().size());
    }

    @Override
    public LicenseCiCounter getCounter() {
        return this.ciCounter;
    }

    @Override
    public boolean isLicenseExpired() {
        return this.license.isDateExpired();
    }

    @Override
    public void validate() {
        this.validateLicenseProperties(this.license);
        this.ciCounter.validate();
    }

    @Override
    public void validate(License license) {
        this.validateLicenseProperties(license);
        LicenseCiCounter tmpCiCounter = LicenseCiCounter.readFrom(license, this.repositoryService);
        tmpCiCounter.validate();
    }

    @Override
    public void reload() {
        this.license = this.readLicense(this.licenseFile);
        this.reLoadCiCounter();
        this.validate();
    }

    @Override
    public License getLicense() {
        return this.license;
    }

    @Override
    public LicenseTransaction startTransaction() {
        return new LicenseTransaction();
    }

    @Override
    public void rollbackTransaction(LicenseTransaction transaction) {
        for (Type type : transaction.getCiCountTypes()) {
            this.ciCounter.getAtomicCiCount(type).addAndGet(-transaction.getCiCount(type));
        }
    }

    protected void validateLicenseProperties(License license) {
        if (license.isDummyLicense()) {
            return;
        }
        String licenseProduct = license.getStringValue(LicenseProperty.PRODUCT);
        if (!this.product.equals(licenseProduct)) {
            throw new InvalidProductException(String.format("License is issued for %s, but used in %s", licenseProduct, this.product));
        }
        if (license.isDateExpired()) {
            throw new LicensePeriodExpiredException("The license has expired.");
        }
        if (!license.isAtLeastVersion(this.minimumLicenseVersion)) {
            throw new InvalidLicenseException(String.format("For this version of %s, a license that is version %s or higher is required.", license.getStringValue(LicenseProperty.PRODUCT), this.minimumLicenseVersion));
        }
    }

    protected abstract License readLicense(File var1);
}

