# NOTE: Please do not edit this file directly
# Create your custom qualifications in the 'ext' folder

# injected:
testRunCis = testRuns.getPreviousRuns(testRun, 5)

# now get the result event from each of the testruns
all_responsetimes = []
print ""
for t in testRunCis:
    eventsInRun = t.getEvents()
    for ev in eventsInRun:
        if ev.type == 'performanceResult':
            all_responsetimes.append(float(ev.get('meanResponseTime.total')))

print 'previous responsetime results', all_responsetimes
avg_responsetime = 0
if len(all_responsetimes) > 0:
    avg_responsetime = sum(all_responsetimes) / len(all_responsetimes)
else:
    print "No history yet. Assuming average response time is infinity"
    avg_responsetime = float('inf')

percentage_ko = 0.0
last_responsetime = 0
total_results = 0

for ev in events:
    if ev.type == 'performanceResult':
        last_responsetime = float(ev.get('meanResponseTime.total'))
        total_results = int(ev.get('numberOfRequests.total'))
        total_ko = int(ev.get('numberOfRequests.ko'))

if total_results == 0:
    result = {"success": False, "reason": "no test results"}
elif float(total_ko / total_results) > 0.1:
    result = {"success": False, "reason": "{:.0%} of tests failed, which is more than 10%".format(float(total_ko / total_results))}
else:
    success = last_responsetime < avg_responsetime * 1.1
    print "success: ", success, "(float(last_responsetime) * 1.1) is: ", (float(last_responsetime) * 1.1), "should be smaller than", avg_responsetime
    result = {"success": success}
    result["reason"] = "Last response time = {:.0f} ms. Average response time = {:.0f} ms. Response time should be lower than average + 10%.".format(last_responsetime, avg_responsetime)

resultHolder.setResult(result)
