/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.FailedToResolveConfigException;

public class Environment {
    private final Settings settings;
    private final File homeFile;
    private final File workFile;
    private final File workWithClusterFile;
    private final File[] dataFiles;
    private final File[] dataWithClusterFiles;
    private final File[] repoFiles;
    private final File configFile;
    private final File pluginsFile;
    private final File logsFile;

    public Environment() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public Environment(Settings settings) {
        String[] repoPaths;
        this.settings = settings;
        this.homeFile = settings.get("path.home") != null ? new File(Strings.cleanPath(settings.get("path.home"))) : new File(System.getProperty("user.dir"));
        this.configFile = settings.get("path.conf") != null ? new File(Strings.cleanPath(settings.get("path.conf"))) : new File(this.homeFile, "config");
        this.pluginsFile = settings.get("path.plugins") != null ? new File(Strings.cleanPath(settings.get("path.plugins"))) : new File(this.homeFile, "plugins");
        this.workFile = settings.get("path.work") != null ? new File(Strings.cleanPath(settings.get("path.work"))) : new File(this.homeFile, "work");
        this.workWithClusterFile = new File(this.workFile, ClusterName.clusterNameFromSettings(settings).value());
        String[] dataPaths = settings.getAsArray("path.data");
        if (dataPaths.length > 0) {
            this.dataFiles = new File[dataPaths.length];
            this.dataWithClusterFiles = new File[dataPaths.length];
            for (int i = 0; i < dataPaths.length; ++i) {
                this.dataFiles[i] = new File(dataPaths[i]);
                this.dataWithClusterFiles[i] = new File(this.dataFiles[i], ClusterName.clusterNameFromSettings(settings).value());
            }
        } else {
            this.dataFiles = new File[]{new File(this.homeFile, "data")};
            this.dataWithClusterFiles = new File[]{new File(new File(this.homeFile, "data"), ClusterName.clusterNameFromSettings(settings).value())};
        }
        if ((repoPaths = settings.getAsArray("path.repo")).length > 0) {
            this.repoFiles = new File[repoPaths.length];
            for (int i = 0; i < repoPaths.length; ++i) {
                this.repoFiles[i] = new File(repoPaths[i]);
            }
        } else {
            this.repoFiles = new File[0];
        }
        this.logsFile = settings.get("path.logs") != null ? new File(Strings.cleanPath(settings.get("path.logs"))) : new File(this.homeFile, "logs");
    }

    public Settings settings() {
        return this.settings;
    }

    public File homeFile() {
        return this.homeFile;
    }

    public File workFile() {
        return this.workFile;
    }

    public File workWithClusterFile() {
        return this.workWithClusterFile;
    }

    public File[] dataFiles() {
        return this.dataFiles;
    }

    public File[] dataWithClusterFiles() {
        return this.dataWithClusterFiles;
    }

    public File[] repoFiles() {
        return this.repoFiles;
    }

    public File resolveRepoFile(String location) {
        return Environment.resolve(this.repoFiles, location);
    }

    public URL resolveRepoURL(URL url) {
        try {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                if (url.getHost() == null || "".equals(url.getHost())) {
                    File file = Environment.resolve(this.repoFiles, url.toURI());
                    if (file == null) {
                        return null;
                    }
                    return file.toURI().toURL();
                }
                return null;
            }
            if ("jar".equals(url.getProtocol())) {
                String file = url.toURI().getSchemeSpecificPart();
                int pos = file.indexOf("!/");
                if (pos < 0) {
                    return null;
                }
                String jarTail = file.substring(pos);
                String filePath = file.substring(0, pos);
                URL internalUrl = new URL(filePath);
                URL normalizedUrl = this.resolveRepoURL(internalUrl);
                if (normalizedUrl == null) {
                    return null;
                }
                return new URL("jar", "", normalizedUrl.toExternalForm() + jarTail);
            }
            return null;
        }
        catch (MalformedURLException ex) {
            return null;
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public File configFile() {
        return this.configFile;
    }

    public File pluginsFile() {
        return this.pluginsFile;
    }

    public File logsFile() {
        return this.logsFile;
    }

    public String resolveConfigAndLoadToString(String path) throws FailedToResolveConfigException, IOException {
        return Streams.copyToString(new InputStreamReader(this.resolveConfig(path).openStream(), Charsets.UTF_8));
    }

    public URL resolveConfig(String path) throws FailedToResolveConfigException {
        File f2;
        String origPath = path;
        File f1 = new File(path);
        if (f1.exists()) {
            try {
                return f1.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new FailedToResolveConfigException("Failed to resolve path [" + f1 + "]", e);
            }
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((f2 = new File(this.configFile, path)).exists()) {
            try {
                return f2.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new FailedToResolveConfigException("Failed to resolve path [" + f2 + "]", e);
            }
        }
        URL resource = this.settings.getClassLoader().getResource(path);
        if (resource != null) {
            return resource;
        }
        if (!path.startsWith("config/") && (resource = this.settings.getClassLoader().getResource("config/" + path)) != null) {
            return resource;
        }
        throw new FailedToResolveConfigException("Failed to resolve config path [" + origPath + "], tried file path [" + f1 + "], path file [" + f2 + "], and classpath");
    }

    public static File resolve(File[] roots, String path) {
        for (File root : roots) {
            Path rootPath = root.toPath().normalize();
            Path normalizedPath = rootPath.resolve(path).normalize();
            if (!normalizedPath.startsWith(rootPath)) continue;
            return normalizedPath.toFile();
        }
        return null;
    }

    public static File resolve(File[] roots, URI uri) {
        return Environment.resolve(roots, Paths.get(uri).normalize().toString());
    }
}

