/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Map;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.indices.analysis.HunspellService;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;

public class IndicesAnalysisModule
extends AbstractModule {
    private final Map<String, Dictionary> hunspellDictionaries = Maps.newHashMap();

    public void addHunspellDictionary(String lang, Dictionary dictionary) {
        this.hunspellDictionaries.put(lang, dictionary);
    }

    @Override
    protected void configure() {
        this.bind(IndicesAnalysisService.class).asEagerSingleton();
        MapBinder<String, Dictionary> dictionariesBinder = MapBinder.newMapBinder(this.binder(), String.class, Dictionary.class);
        for (Map.Entry<String, Dictionary> entry : this.hunspellDictionaries.entrySet()) {
            dictionariesBinder.addBinding(entry.getKey()).toInstance(entry.getValue());
        }
        this.bind(HunspellService.class).asEagerSingleton();
    }
}

