/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Locale;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Booleans;

enum ScriptMode {
    ON,
    OFF,
    SANDBOX;


    static ScriptMode parse(String input) {
        if (Booleans.isExplicitTrue(input = input.toLowerCase(Locale.ROOT))) {
            return ON;
        }
        if (Booleans.isExplicitFalse(input)) {
            return OFF;
        }
        if (SANDBOX.toString().equals(input)) {
            return SANDBOX;
        }
        throw new ElasticsearchIllegalArgumentException("script mode [" + input + "] not supported");
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

