/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.NXYSignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;

public class MutualInformation
extends NXYSignificanceHeuristic {
    protected static final ParseField NAMES_FIELD = new ParseField("mutual_information", new String[0]);
    private static final double log2 = Math.log(2.0);
    public static final SignificanceHeuristicStreams.Stream STREAM = new SignificanceHeuristicStreams.Stream(){

        @Override
        public SignificanceHeuristic readResult(StreamInput in) throws IOException {
            return new MutualInformation(in.readBoolean(), in.readBoolean());
        }

        @Override
        public String getName() {
            return NAMES_FIELD.getPreferredName();
        }
    };

    public MutualInformation(boolean includeNegatives, boolean backgroundIsSuperset) {
        super(includeNegatives, backgroundIsSuperset);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof MutualInformation)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int result = NAMES_FIELD.getPreferredName().hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        NXYSignificanceHeuristic.Frequencies frequencies = this.computeNxys(subsetFreq, subsetSize, supersetFreq, supersetSize, "MutualInformation");
        double score = (this.getMITerm(frequencies.N00, frequencies.N0_, frequencies.N_0, frequencies.N) + this.getMITerm(frequencies.N01, frequencies.N0_, frequencies.N_1, frequencies.N) + this.getMITerm(frequencies.N10, frequencies.N1_, frequencies.N_0, frequencies.N) + this.getMITerm(frequencies.N11, frequencies.N1_, frequencies.N_1, frequencies.N)) / log2;
        if (Double.isNaN(score)) {
            score = Double.NEGATIVE_INFINITY;
        }
        if (!this.includeNegatives && frequencies.N11 / frequencies.N_1 < frequencies.N10 / frequencies.N_0) {
            score = Double.NEGATIVE_INFINITY;
        }
        return score;
    }

    double getMITerm(double Nxy, double Nx_, double N_y, double N) {
        double numerator = Math.abs(N * Nxy);
        double denominator = Math.abs(Nx_ * N_y);
        double factor = Math.abs(Nxy / N);
        if (numerator < 1.0E-7 && factor < 1.0E-7) {
            return 0.0;
        }
        return factor * Math.log(numerator / denominator);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
        super.writeTo(out);
    }

    public static class MutualInformationBuilder
    extends NXYSignificanceHeuristic.NXYBuilder {
        public MutualInformationBuilder(boolean includeNegatives, boolean backgroundIsSuperset) {
            super(includeNegatives, backgroundIsSuperset);
        }

        @Override
        public void toXContent(XContentBuilder builder) throws IOException {
            builder.startObject(STREAM.getName());
            super.build(builder);
            builder.endObject();
        }
    }

    public static class MutualInformationParser
    extends NXYSignificanceHeuristic.NXYParser {
        @Override
        protected SignificanceHeuristic newHeuristic(boolean includeNegatives, boolean backgroundIsSuperset) {
            return new MutualInformation(includeNegatives, backgroundIsSuperset);
        }

        @Override
        public String[] getNames() {
            return NAMES_FIELD.getAllNamesIncludedDeprecated();
        }
    }
}

