/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConnectionOptions {
    public static final String OPERATING_SYSTEM = "os";
    public static final String TEMPORARY_DIRECTORY_PATH = "tmp";
    public static final String TEMPORARY_DIRECTORY_DELETE_ON_DISCONNECT = "tmpDeleteOnDisconnect";
    public static final boolean TEMPORARY_DIRECTORY_DELETE_ON_DISCONNECT_DEFAULT = true;
    public static final String TEMPORARY_FILE_CREATION_RETRIES = "tmpFileCreationRetries";
    public static final int TEMPORARY_FILE_CREATION_RETRIES_DEFAULT = 100;
    public static final String CONNECTION_TIMEOUT_MILLIS = "connectionTimeoutMillis";
    public static final int CONNECTION_TIMEOUT_MILLIS_DEFAULT = 120000;
    public static final String SOCKET_TIMEOUT_MILLIS = "socketTimeoutMillis";
    public static final int SOCKET_TIMEOUT_MILLIS_DEFAULT = 0;
    public static final String ADDRESS = "address";
    public static final String PORT = "port";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String JUMPSTATION = "jumpstation";
    public static final String FILE_COPY_COMMAND_FOR_UNIX = "fileCopyCommandForUnix";
    public static final String FILE_COPY_COMMAND_FOR_UNIX_DEFAULT = "cp -p {0} {1}";
    public static final String DIRECTORY_COPY_COMMAND_FOR_UNIX = "directoryCopyCommandForUnix";
    public static final String DIRECTORY_COPY_COMMAND_FOR_UNIX_DEFAULT = "cd {1} ; tar -cf - -C {0} . | tar xpf -";
    public static final String FILE_COPY_COMMAND_FOR_WINDOWS = "fileCopyCommandForWindows";
    public static final String FILE_COPY_COMMAND_FOR_WINDOWS_DEFAULT = "copy {0} {1} /y";
    public static final String DIRECTORY_COPY_COMMAND_FOR_WINDOWS = "directoryCopyCommandForWindows";
    public static final String DIRECTORY_COPY_COMMAND_FOR_WINDOWS_DEFAULT = "xcopy {0} {1} /i /y /s /e /h /q";
    public static final String FILE_COPY_COMMAND_FOR_ZOS = "fileCopyCommandForZos";
    public static final String FILE_COPY_COMMAND_FOR_ZOS_DEFAULT = "cp -p {0} {1}";
    public static final String DIRECTORY_COPY_COMMAND_FOR_ZOS = "directoryCopyCommandForZos";
    public static final String DIRECTORY_COPY_COMMAND_FOR_ZOS_DEFAULT = "tar cC {0} . | tar xmC {1}";
    public static final String REMOTE_COPY_BUFFER_SIZE = "remoteCopyBufferSize";
    public static final int REMOTE_COPY_BUFFER_SIZE_DEFAULT = 65536;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private static final Set<String> filteredKeys = ConnectionOptions.getFilteredKeys();

    private static Set<String> getFilteredKeys() {
        HashSet<String> strings = new HashSet<String>();
        strings.add(PASSWORD);
        strings.add("passphrase");
        strings.add("privateKey");
        return Collections.unmodifiableSet(strings);
    }

    public ConnectionOptions() {
    }

    public ConnectionOptions(ConnectionOptions options) {
        this();
        this.options.putAll(options.options);
    }

    public void set(String key, Object value) {
        this.options.put(key, value);
    }

    public <T> T get(String key) throws IllegalArgumentException {
        Object value = this.options.get(key);
        if (value == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + key);
        }
        return (T)value;
    }

    public <T> T getOptional(String key) {
        return (T)this.options.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        if (this.options.containsKey(key)) {
            return (T)this.options.get(key);
        }
        return defaultValue;
    }

    public boolean getBoolean(String key) {
        Object o = this.options.get(key);
        if (o == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + key);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        throw new IllegalArgumentException("Value specified for required connection option " + key + " is neither a Boolean nor a String");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object o = this.options.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        throw new IllegalArgumentException("Value specified for connection option " + key + " is neither a Boolean nor a String");
    }

    public int getInteger(String key) {
        Object o = this.options.get(key);
        if (o == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + key);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("Value specified for required connection option " + key + " is neither an Integer nor a String");
    }

    public int getInteger(String key, int defaultValue) {
        Object o = this.options.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("Value specified for connection option " + key + " is neither an Integer nor a String");
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClazz) {
        Object o = this.options.get(key);
        if (o == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + key);
        }
        if (o.getClass().equals(enumClazz)) {
            return (T)((Enum)o);
        }
        if (o instanceof String) {
            return Enum.valueOf(enumClazz, (String)o);
        }
        throw new IllegalArgumentException("Value specified for required connection option " + key + " is neither an " + enumClazz.getName() + " nor a String");
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClazz, T defaultValue) {
        Object o = this.options.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (o.getClass().equals(enumClazz)) {
            return (T)((Enum)o);
        }
        if (o instanceof String) {
            return Enum.valueOf(enumClazz, (String)o);
        }
        throw new IllegalArgumentException("Value specified for connection option " + key + " is neither an instanceof of " + enumClazz.getName() + " nor a String");
    }

    public boolean containsKey(String key) {
        return this.options.containsKey(key);
    }

    public Set<String> keys() {
        return this.options.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionOptions that = (ConnectionOptions)o;
        return this.options.equals(that.options);
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public String toString() {
        return ConnectionOptions.print(this, "");
    }

    private static String print(ConnectionOptions options, String indent) {
        StringBuilder b = new StringBuilder();
        b.append("ConnectionOptions[\n");
        for (Map.Entry<String, Object> e : options.options.entrySet()) {
            b.append(indent).append("\t").append(e.getKey()).append(" --> ");
            Object value = e.getValue();
            if (value instanceof ConnectionOptions) {
                b.append(ConnectionOptions.print((ConnectionOptions)value, indent + "\t"));
            } else {
                b.append(filteredKeys.contains(e.getKey()) ? "********" : value);
            }
            b.append("\n");
        }
        b.append(indent).append("]");
        return b.toString();
    }
}

