/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlElement;
import fitnesse.html.RawHtml;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HtmlTag
extends HtmlElement
implements Iterable<HtmlElement> {
    private final LinkedList<HtmlElement> childTags = new LinkedList();
    private final List<Attribute> attributes = new LinkedList<Attribute>();
    private final String tagName;
    private boolean isInline;

    public HtmlTag(String tagName) {
        this.tagName = tagName;
    }

    public HtmlTag(String tagName, String content) {
        this(tagName);
        this.add(content);
    }

    public HtmlTag(String tagName, HtmlElement child) {
        this(tagName);
        this.add(child);
    }

    public String tagName() {
        return this.tagName;
    }

    @Override
    public String html() {
        return this.html(0);
    }

    public String htmlInline() {
        this.isInline = true;
        return this.html(0);
    }

    public String html(int depth) {
        return new HtmlFormatter(depth).format();
    }

    private boolean hasChildren() {
        return !this.childTags.isEmpty();
    }

    public void add(String s) {
        this.add(new RawHtml(s));
    }

    public void add(HtmlElement element) {
        this.childTags.add(element);
    }

    public void addAttribute(String key, String value) {
        this.attributes.add(new Attribute(key, value));
    }

    public void use(String s) {
        this.use(new RawHtml(s));
    }

    public void use(HtmlElement element) {
        this.childTags.clear();
        this.add(element);
    }

    public String getAttribute(String key) {
        for (Attribute attribute : this.attributes) {
            if (key == null || !key.equals(attribute.name)) continue;
            return attribute.value;
        }
        return null;
    }

    protected String makeIndent(int depth) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            indent.append('\t');
        }
        return indent.toString();
    }

    @Override
    public Iterator<HtmlElement> iterator() {
        return this.childTags.iterator();
    }

    private class HtmlFormatter {
        private int depth;
        private boolean childTagWasMade;
        private boolean lastMadeChildWasNotTag;
        private boolean firstElement;

        public HtmlFormatter(int depth) {
            this.depth = depth;
        }

        public String format() {
            return this.makeTabs() + this.makeTag() + this.makeAttributes() + this.makeTagEnd() + this.makeChildren() + this.makeEndTag() + this.makeLineEnd();
        }

        private String makeEndTag() {
            return HtmlTag.this.hasChildren() ? "</" + HtmlTag.this.tagName() + ">" : "";
        }

        private String makeLineEnd() {
            return HtmlTag.this.isInline ? "" : HtmlElement.endl;
        }

        private String makeChildren() {
            String children = "";
            if (HtmlTag.this.hasChildren()) {
                children = this.makeChildrenWithoutTrailingIndent();
                if (this.childTagWasMade && !HtmlTag.this.isInline) {
                    children = children + this.makeTabs();
                }
            }
            return children;
        }

        private String makeChildrenWithoutTrailingIndent() {
            StringBuilder children = new StringBuilder(64);
            this.childTagWasMade = false;
            this.lastMadeChildWasNotTag = false;
            this.firstElement = true;
            for (HtmlElement element : HtmlTag.this.childTags) {
                children.append(this.makeChildFromElement(element));
                this.firstElement = false;
            }
            return children.toString();
        }

        private String makeChildFromElement(HtmlElement element) {
            boolean childIsTag = element instanceof HtmlTag;
            String child = childIsTag ? this.makeChildFromTag((HtmlTag)element) : element.html();
            this.prepareForNextElement(childIsTag);
            return child;
        }

        private void prepareForNextElement(boolean childIsTag) {
            this.childTagWasMade |= childIsTag;
            this.lastMadeChildWasNotTag = !childIsTag;
        }

        private String makeChildFromTag(HtmlTag element) {
            return (this.childShouldStartWithNewLine() ? HtmlElement.endl : "") + element.html(this.depth + 1);
        }

        private boolean childShouldStartWithNewLine() {
            return (this.firstElement || this.lastMadeChildWasNotTag) && !HtmlTag.this.isInline;
        }

        private String makeTagEnd() {
            return HtmlTag.this.hasChildren() ? ">" : "/>";
        }

        private String makeAttributes() {
            StringBuilder attributes = new StringBuilder();
            for (Attribute attribute : HtmlTag.this.attributes) {
                attributes.append(" ").append(attribute.name).append("=\"").append(attribute.value).append("\"");
            }
            return attributes.toString();
        }

        private String makeTag() {
            return "<" + HtmlTag.this.tagName();
        }

        private String makeTabs() {
            return HtmlTag.this.makeIndent(this.depth);
        }
    }

    public static class Attribute {
        public String name;
        public String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

