/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html.template;

import fitnesse.html.template.PageTitle;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class HtmlPage {
    private static final String HEADER_TEMPLATE = "header.vm";
    private static final String TITLE = "FitNesse";
    private VelocityEngine velocityEngine;
    private VelocityContext velocityContext;
    private String templateFileName;

    public HtmlPage(VelocityEngine velocityEngine, String templateFileName, String theme, String contextRoot) {
        this.velocityEngine = velocityEngine;
        this.templateFileName = templateFileName;
        this.velocityContext = new VelocityContext();
        this.setHeaderTemplate(HEADER_TEMPLATE);
        this.setTitle(TITLE);
        this.velocityContext.put("theme", (Object)theme);
        this.velocityContext.put("contextRoot", (Object)contextRoot);
    }

    public void setHeaderTemplate(String headerTemplate) {
        this.velocityContext.put("headerTemplate", (Object)this.ensureSuffix(headerTemplate));
    }

    public void setNavTemplate(String navTemplate) {
        this.velocityContext.put("navTemplate", (Object)this.ensureSuffix(navTemplate));
    }

    public void setMainTemplate(String mainTemplate) {
        this.setBodyClass(mainTemplate);
        this.velocityContext.put("mainTemplate", (Object)this.ensureSuffix(mainTemplate));
    }

    public void setFooterTemplate(String footerTemplate) {
        this.velocityContext.put("footerTemplate", (Object)this.ensureSuffix(footerTemplate));
    }

    public void setErrorNavTemplate(String errorNavTemplate) {
        this.velocityContext.put("errorNavTemplate", (Object)this.ensureSuffix(errorNavTemplate));
    }

    public String ensureSuffix(String templateName) {
        if (templateName.endsWith(".vm")) {
            return templateName;
        }
        return templateName + ".vm";
    }

    public void put(String key, Object value) {
        this.velocityContext.put(key, value);
    }

    public String html() {
        StringWriter writer = new StringWriter();
        this.render(writer);
        return writer.toString();
    }

    public void render(Writer writer) {
        Template template = this.velocityEngine.getTemplate(this.templateFileName);
        template.merge((Context)this.velocityContext, writer);
    }

    public void setTitle(String title) {
        this.velocityContext.put("title", (Object)title);
    }

    public void addTitles(String title) {
        this.setTitle(title);
        this.setPageTitle(new PageTitle(title));
    }

    public void setPageTitle(PageTitle pageTitle) {
        this.velocityContext.put("pageTitle", (Object)pageTitle);
    }

    public void setBodyClass(String bodyClass) {
        this.velocityContext.put("bodyClass", (Object)bodyClass);
    }
}

