/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import util.StreamReader;

public class InputStreamResponse
extends Response {
    private StreamReader reader;
    private int contentSize = 0;

    public InputStreamResponse() {
        super("html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendTo(ResponseSender sender) throws IOException {
        try {
            sender.send(this.makeHttpHeaders().getBytes());
            while (!this.reader.isEof()) {
                sender.send(this.reader.readBytes(1000));
            }
        }
        finally {
            this.reader.close();
            sender.close();
        }
    }

    @Override
    protected void addContentHeaders() {
        super.addContentHeaders();
        this.addHeader("Content-Length", this.getContentSize() + "");
    }

    @Override
    public int getContentSize() {
        return this.contentSize;
    }

    public void setBody(InputStream input, int size) {
        this.reader = new StreamReader(input);
        this.contentSize = size;
    }

    public void setBody(File file) throws FileNotFoundException {
        FileInputStream input = new FileInputStream(file);
        int size = (int)file.length();
        this.setBody(input, size);
    }
}

