/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.ExecutionStatus;
import fitnesse.testrunner.TestsRunnerListener;
import fitnesse.testrunner.WikiTestPageUtil;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import java.io.Writer;

public abstract class InteractiveFormatter
extends BaseFormatter
implements TestsRunnerListener {
    private static final String TESTING_INTERRUPTED = "<strong>Testing was interrupted and results are incomplete.</strong>&nbsp;";
    private final Writer writer;
    private boolean wasInterrupted = false;
    private TestSummary assertionCounts = new TestSummary();
    private String relativeName;

    protected InteractiveFormatter(WikiPage page, Writer writer) {
        super(page);
        this.writer = writer;
    }

    protected void writeData(String output) throws IOException {
        this.writer.write(output);
    }

    protected void updateSummaryDiv(String html) throws IOException {
        this.writeData(HtmlUtil.makeReplaceElementScript("test-summary", html).html());
    }

    protected String getRelativeName() {
        return this.relativeName;
    }

    protected String getRelativeName(TestPage testPage) {
        PageCrawler pageCrawler = this.getPage().getPageCrawler();
        String relativeName = pageCrawler.getRelativeName(WikiTestPageUtil.getSourcePage(testPage));
        if ("".equals(relativeName)) {
            relativeName = String.format("(%s)", testPage.getName());
        }
        return relativeName;
    }

    protected void addStopLink(String stopResponderId) throws IOException {
        String link = "?responder=stoptest&id=" + stopResponderId;
        HtmlTag status = HtmlUtil.makeSilentLink(link, new RawHtml("Stop Test"));
        status.addAttribute("class", "stop");
        this.writeData(HtmlUtil.makeReplaceElementScript("test-action", status.html()).html());
    }

    protected void removeStopTestLink() throws IOException {
        HtmlTag script = HtmlUtil.makeReplaceElementScript("test-action", "");
        this.writeData(script.html());
    }

    public TestSummary getAssertionCounts() {
        return this.assertionCounts;
    }

    @Override
    public int getErrorCount() {
        return this.getAssertionCounts().getWrong() + this.getAssertionCounts().getExceptions();
    }

    public boolean wasInterrupted() {
        return this.wasInterrupted;
    }

    private void errorOccurred(Throwable cause) {
        this.wasInterrupted = true;
        try {
            this.writeData(String.format("<span class=\"error\">Could not complete testing: %s</span>", cause.toString()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write response to output: " + cause.toString(), e);
        }
    }

    @Override
    public void testSystemStopped(TestSystem testSystem, Throwable cause) {
        if (cause != null) {
            this.errorOccurred(cause);
        }
    }

    @Override
    public void testStarted(TestPage testPage) throws IOException {
        this.relativeName = this.getRelativeName(testPage);
    }

    public String testSummary() {
        String summaryContent = this.wasInterrupted ? TESTING_INTERRUPTED : "";
        summaryContent = summaryContent + this.makeSummaryContent();
        HtmlTag script = HtmlUtil.makeReplaceElementScript("test-summary", summaryContent);
        script.add("document.getElementById(\"test-summary\").className = \"" + (Object)((Object)(this.wasInterrupted ? ExecutionResult.ERROR : ExecutionResult.getExecutionResult(this.relativeName, this.getAssertionCounts()))) + "\";");
        return script.html();
    }

    protected abstract String makeSummaryContent();

    public void finishWritingOutput() throws IOException {
        this.writeData(this.testSummary());
    }

    @Override
    public void announceNumberTestsToRun(int testsToRun) {
    }

    @Override
    public void unableToStartTestSystem(String testSystemName, Throwable cause) throws IOException {
        this.writeData(String.format("<span class=\"error\">Unable to start test system '%s': %s</span>", testSystemName, cause.toString()));
    }

    public void setTrackingId(String stopResponderId) throws IOException {
        this.addStopLink(stopResponderId);
    }

    protected void AddLogLink() throws IOException {
        this.writeData(HtmlUtil.makeReplaceElementScript("test-action", this.executionStatus()).html());
    }

    protected void maybeMakeErrorNavigatorVisible() throws IOException {
        if (this.exceptionsOrErrorsExist()) {
            this.writeData(this.initErroMetadata());
        }
    }

    private boolean exceptionsOrErrorsExist() {
        return this.assertionCounts.getExceptions() + this.assertionCounts.getWrong() > 0;
    }

    public String executionStatus() {
        if (this.wasInterrupted) {
            return InteractiveFormatter.makeExecutionStatusLink(ExecutionStatus.ERROR);
        }
        return InteractiveFormatter.makeExecutionStatusLink(ExecutionStatus.OK);
    }

    private String initErroMetadata() {
        HtmlTag init = HtmlUtil.makeInitErrorMetadataScript();
        return init.html();
    }

    public static String makeExecutionStatusLink(ExecutionStatus executionStatus) {
        HtmlTag status = HtmlUtil.makeLink("?executionLog", executionStatus.getMessage());
        status.addAttribute("class", executionStatus.getStyle());
        return status.html();
    }
}

