/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.FitNesseContext;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.history.SuiteHistoryFormatter;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.wiki.WikiPage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.xml.sax.SAXException;

public class JunitReFormatter
extends BaseFormatter
implements Closeable {
    private final FitNesseContext context;
    private final Writer writer;
    private final SuiteHistoryFormatter historyFormatter;

    public JunitReFormatter(FitNesseContext context, WikiPage page, Writer writer, SuiteHistoryFormatter historyFormatter) {
        super(page);
        this.context = context;
        this.writer = writer;
        this.historyFormatter = historyFormatter;
    }

    @Override
    public void close() throws IOException {
        this.historyFormatter.close();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("formatter", (Object)this);
        velocityContext.put("suiteExecutionReport", (Object)this.historyFormatter.getSuiteExecutionReport());
        VelocityEngine velocityEngine = this.context.pageFactory.getVelocityEngine();
        Template template = velocityEngine.getTemplate("suiteJunit.vm");
        template.merge((Context)velocityContext, this.writer);
        this.writer.close();
    }

    @Override
    public int getErrorCount() {
        return this.historyFormatter.getErrorCount();
    }

    TestExecutionReport makeTestExecutionReport(File file) throws IOException, SAXException {
        return new TestExecutionReport(file);
    }
}

