/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import util.StreamReader;

public class SlimStreamReader
extends StreamReader {
    public SlimStreamReader(InputStream input) {
        super(input);
    }

    public static void sendSlimMessage(OutputStream writer, String message) throws IOException {
        byte[] msgChars = message.getBytes("UTF-8");
        byte[] msgLength = String.format("%06d:", msgChars.length).getBytes("UTF-8");
        writer.write(msgLength, 0, msgLength.length);
        writer.write(msgChars, 0, msgChars.length);
        writer.flush();
    }

    public static void sendSlimHeader(OutputStream writer, String header) throws IOException {
        byte[] msgChars = header.getBytes("UTF-8");
        writer.write(msgChars, 0, msgChars.length);
        writer.flush();
    }

    private int getLengthToRead() throws IOException {
        String next;
        String length = this.read(6);
        while (!(":".equals(next = this.read(1)) || this.isEof() || this.isTimeout())) {
            length = length + next;
        }
        if (this.isEof()) {
            throw new IOException("Stream Read Failure. Can't read length of message, EOF reached.  Possibly test aborted.  Last things read: " + length);
        }
        if (this.isTimeout()) {
            throw new IOException("Stream Read Failure. Can't read length of message, Timeout reached.  Possibly test aborted.  Last things read: " + length);
        }
        try {
            Integer resultLength = Integer.parseInt(length);
            return resultLength;
        }
        catch (NumberFormatException e) {
            throw new IOException("Stream Read Failure. Can't read length of message, not a number.  Possibly test aborted.  Last things read: " + length);
        }
    }

    public String getSlimMessage() throws IOException {
        int resultLength = this.getLengthToRead();
        return this.read(resultLength);
    }

    public static SlimStreamReader getReader(Socket socket) throws IOException {
        return new SlimStreamReader(new BufferedInputStream(socket.getInputStream()));
    }

    public static OutputStream getByteWriter(Socket socket) throws IOException {
        return new BufferedOutputStream(socket.getOutputStream());
    }
}

