/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.MethodExecutor;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimExecutionContext;
import fitnesse.slim.SystemUnderTest;
import java.lang.reflect.Field;

public class SystemUnderTestMethodExecutor
extends MethodExecutor {
    private final SlimExecutionContext context;

    public SystemUnderTestMethodExecutor(SlimExecutionContext context) {
        this.context = context;
    }

    @Override
    public MethodExecutionResult execute(String instanceName, String methodName, Object[] args) throws Throwable {
        Object instance;
        try {
            instance = this.context.getInstance(instanceName);
        }
        catch (SlimError e) {
            return MethodExecutionResult.noInstance(instanceName + "." + methodName);
        }
        Field field = this.findSystemUnderTest(methodName, instance.getClass(), args);
        if (field != null) {
            Object systemUnderTest = field.get(instance);
            return this.findAndInvoke(methodName, args, systemUnderTest);
        }
        return MethodExecutionResult.noMethod(methodName, instance.getClass(), args.length);
    }

    private Field findSystemUnderTest(String methodName, Class<?> k, Object[] args) {
        Field[] fields;
        for (Field field : fields = k.getDeclaredFields()) {
            if (!this.isSystemUnderTest(field) || null == this.findMatchingMethod(methodName, field.getType(), args.length)) continue;
            return field;
        }
        return null;
    }

    private boolean isSystemUnderTest(Field field) {
        return "systemUnderTest".equals(field.getName()) || field.getAnnotation(SystemUnderTest.class) != null;
    }
}

