/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.NameTranslator;
import fitnesse.slim.SlimException;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;
import java.util.Arrays;

public class CallInstruction
extends Instruction {
    public static final String INSTRUCTION = "call";
    private String instanceName;
    private String methodName;
    private Object[] args;

    public CallInstruction(String id, String instanceName, String methodName) {
        this(id, instanceName, methodName, new Object[0]);
    }

    public CallInstruction(String id, String instanceName, String methodName, Object[] args) {
        super(id);
        this.instanceName = instanceName;
        this.methodName = methodName;
        this.args = args;
    }

    public CallInstruction(String id, String instanceName, String methodName, Object[] args, NameTranslator methodNameTranslator) {
        super(id);
        this.instanceName = instanceName;
        this.methodName = methodNameTranslator.translate(methodName);
        this.args = args;
    }

    @Override
    protected InstructionResult executeInternal(InstructionExecutor executor) throws SlimException {
        Object result = executor.call(this.instanceName, this.methodName, this.args);
        return new InstructionResult(this.getId(), result);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id='").append(this.getId()).append('\'');
        sb.append(", instruction='").append(INSTRUCTION).append('\'');
        sb.append(", instanceName='").append(this.instanceName).append('\'');
        sb.append(", methodName='").append(this.methodName).append('\'');
        sb.append(", args=").append(this.args == null ? "null" : Arrays.asList(this.args).toString());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CallInstruction that = (CallInstruction)o;
        if (!Arrays.equals(this.args, that.args)) {
            return false;
        }
        if (!this.instanceName.equals(that.instanceName)) {
            return false;
        }
        return this.methodName.equals(that.methodName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.instanceName.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }
}

