/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import java.security.Permission;

public class SystemExitSecurityManager
extends SecurityManager {
    public static final String PREVENT_SYSTEM_EXIT = "prevent.system.exit";
    private SecurityManager delegate;

    private SystemExitSecurityManager(SecurityManager delegate) {
        this.delegate = delegate;
    }

    public static void activateIfWanted() {
        if (SystemExitSecurityManager.isPreventSystemExit()) {
            SecurityManager currentSecMgr = System.getSecurityManager();
            SystemExitSecurityManager systemExitSecurityManager = new SystemExitSecurityManager(currentSecMgr);
            System.setSecurityManager(systemExitSecurityManager);
        }
    }

    public static void restoreOriginalSecurityManager() {
        SecurityManager currentSecMgr = System.getSecurityManager();
        if (currentSecMgr != null && currentSecMgr instanceof SystemExitSecurityManager) {
            SecurityManager originalSecurityManager = ((SystemExitSecurityManager)currentSecMgr).delegate;
            System.setSecurityManager(originalSecurityManager);
        }
    }

    private static boolean isPreventSystemExit() {
        String preventSystemExitString = System.getProperty(PREVENT_SYSTEM_EXIT);
        if (preventSystemExitString != null) {
            return Boolean.parseBoolean(preventSystemExitString);
        }
        return true;
    }

    @Override
    public void checkExit(int status) {
        throw new SystemExitException("prevented system exit with exit code " + status);
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.delegate != null) {
            this.delegate.checkPermission(perm, context);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.delegate != null) {
            this.delegate.checkPermission(perm);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.delegate != null) {
            this.delegate.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (this.delegate != null) {
            this.delegate.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (this.delegate != null) {
            this.delegate.checkAccess(g);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.delegate != null) {
            this.delegate.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.delegate != null) {
            this.delegate.checkLink(lib);
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.delegate != null) {
            this.delegate.checkRead(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.delegate != null) {
            this.delegate.checkRead(file, context);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.delegate != null) {
            this.delegate.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.delegate != null) {
            this.delegate.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.delegate != null) {
            this.delegate.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.delegate != null) {
            this.delegate.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.delegate != null) {
            this.delegate.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.delegate != null) {
            this.delegate.checkAccept(host, port);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.delegate != null) {
            this.delegate.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.delegate != null) {
            this.delegate.checkPropertyAccess(key);
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        if (this.delegate != null) {
            return this.delegate.checkTopLevelWindow(window);
        }
        return false;
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.delegate != null) {
            this.delegate.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.delegate != null) {
            this.delegate.checkSystemClipboardAccess();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.delegate != null) {
            this.delegate.checkAwtEventQueueAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.delegate != null) {
            this.delegate.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.delegate != null) {
            this.delegate.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.delegate != null) {
            this.delegate.checkSetFactory();
        }
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (this.delegate != null) {
            this.delegate.checkMemberAccess(clazz, which);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.delegate != null) {
            this.delegate.checkSecurityAccess(target);
        }
    }

    public static class SystemExitException
    extends SecurityException {
        private static final long serialVersionUID = 2584644457111168436L;

        public SystemExitException(String message) {
            super(message);
        }
    }
}

