/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.protocol;

import fitnesse.slim.protocol.SyntaxError;
import java.util.ArrayList;
import java.util.List;

public class SlimDeserializer {
    private List<Object> result;
    private String serialized;
    private int index = 0;

    public static List<Object> deserialize(String serialized) {
        return new SlimDeserializer(serialized).deserialize();
    }

    public SlimDeserializer(String serialized) {
        this.serialized = serialized;
    }

    public List<Object> deserialize() {
        try {
            this.checkSerializedStringIsValid();
            return this.deserializeString();
        }
        catch (Exception e) {
            throw new SyntaxError(e);
        }
    }

    private void checkSerializedStringIsValid() {
        if (this.serialized == null) {
            throw new SyntaxError("Can't deserialize null");
        }
        if (this.serialized.isEmpty()) {
            throw new SyntaxError("Can't deserialize empty string");
        }
    }

    private List<Object> deserializeString() {
        this.checkForOpenBracket();
        List<Object> result = this.deserializeList();
        this.checkForClosedBracket();
        return result;
    }

    private void checkForClosedBracket() {
        if (!this.charsLeft() || this.getChar() != ']') {
            throw new SyntaxError("Serialized list has no ending ]");
        }
    }

    private boolean charsLeft() {
        return this.index < this.serialized.length();
    }

    private void checkForOpenBracket() {
        if (this.getChar() != '[') {
            throw new SyntaxError("Serialized list has no starting [");
        }
    }

    private List<Object> deserializeList() {
        this.result = new ArrayList<Object>();
        int itemCount = this.getLength();
        for (int i = 0; i < itemCount; ++i) {
            this.deserializeItem();
        }
        return this.result;
    }

    private void deserializeItem() {
        int itemLength = this.getLength();
        String item = this.getString(itemLength);
        List<Object> sublist = this.maybeReadList(item);
        if (sublist == null) {
            this.result.add(item);
        } else {
            this.result.add(sublist);
        }
    }

    private List<Object> maybeReadList(String string) {
        if ("".equals(string.trim()) || !string.startsWith("[")) {
            return null;
        }
        try {
            return SlimDeserializer.deserialize(string);
        }
        catch (SyntaxError e) {
            return null;
        }
    }

    private String getString(int length) {
        String result = this.serialized.substring(this.index, this.index + length);
        this.index += length;
        this.checkForColon("String");
        return result;
    }

    private void checkForColon(String itemType) {
        if (this.getChar() != ':') {
            throw new SyntaxError(itemType + " in serialized list not terminated by colon.");
        }
    }

    private char getChar() {
        return this.serialized.charAt(this.index++);
    }

    private int getLength() {
        try {
            return this.tryGetLength();
        }
        catch (NumberFormatException e) {
            throw new SyntaxError(e);
        }
    }

    private int tryGetLength() {
        Integer next;
        int lengthSize = 6;
        String lengthString = this.serialized.substring(this.index, this.index + lengthSize);
        int length = Integer.parseInt(lengthString);
        this.index += lengthSize;
        while ((next = this.maybeReadDigit()) != null) {
            length = length * 10 + next;
        }
        this.checkForColon("Length");
        return length;
    }

    private Integer maybeReadDigit() {
        char next = this.serialized.charAt(this.index);
        if (Character.isDigit(next)) {
            ++this.index;
            return Character.digit(next, 10);
        }
        return null;
    }
}

