/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.testsystems.ExecutionLogListener;
import java.util.LinkedList;
import java.util.List;

public class CompositeExecutionLogListener
implements ExecutionLogListener {
    private final List<ExecutionLogListener> listeners = new LinkedList<ExecutionLogListener>();

    public final void addExecutionLogListener(ExecutionLogListener listener) {
        this.listeners.add(listener);
    }

    protected final List<ExecutionLogListener> listeners() {
        return this.listeners;
    }

    @Override
    public void commandStarted(ExecutionLogListener.ExecutionContext context) {
        for (ExecutionLogListener listener : this.listeners) {
            listener.commandStarted(context);
        }
    }

    @Override
    public void stdOut(String output) {
        for (ExecutionLogListener listener : this.listeners) {
            listener.stdOut(output);
        }
    }

    @Override
    public void stdErr(String output) {
        for (ExecutionLogListener listener : this.listeners) {
            listener.stdErr(output);
        }
    }

    @Override
    public void exitCode(int exitCode) {
        for (ExecutionLogListener listener : this.listeners) {
            listener.exitCode(exitCode);
        }
    }

    @Override
    public void exceptionOccurred(Throwable e) {
        for (ExecutionLogListener listener : this.listeners) {
            listener.exceptionOccurred(e);
        }
    }
}

