/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.SlimError;
import fitnesse.slim.SlimStreamReader;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimListBuilder;
import fitnesse.slim.protocol.SlimSerializer;
import fitnesse.socketservice.SocketFactory;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.slim.SlimClient;
import fitnesse.util.Clock;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SlimCommandRunningClient
implements SlimClient {
    private static final Logger LOG = Logger.getLogger(SlimCommandRunningClient.class.getName());
    public static final int NO_SLIM_SERVER_CONNECTION_FLAG = -32000;
    public static double MINIMUM_REQUIRED_SLIM_VERSION = 0.3;
    private final CommandRunner slimRunner;
    private final int connectionTimeout;
    private final double requiredSlimVersion;
    private Socket client;
    private SlimStreamReader reader;
    private OutputStream writer;
    private String slimServerVersionMessage;
    private double slimServerVersion;
    private String hostName;
    private int port;
    private boolean useSSL;
    private String sslParameterClassName;

    public SlimCommandRunningClient(CommandRunner slimRunner, String hostName, int port, int connectionTimeout, double requiredSlimVersion, boolean useSSL, String sslParameterClassName) {
        this.slimRunner = slimRunner;
        this.hostName = hostName;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
        this.requiredSlimVersion = requiredSlimVersion;
        this.useSSL = useSSL;
        this.sslParameterClassName = sslParameterClassName;
    }

    @Override
    public void start() throws IOException {
        this.slimRunner.asynchronousStart();
        this.connect();
        this.checkForVersionMismatch();
    }

    private void checkForVersionMismatch() {
        double serverVersionNumber = this.getServerVersion();
        if (serverVersionNumber == -32000.0) {
            throw new SlimError("Slim Protocol Version Error: Server did not respond with a valid version number.");
        }
        if (serverVersionNumber < this.requiredSlimVersion) {
            throw new SlimError(String.format("Slim Protocol Version Error: Expected V%s but was V%s", this.requiredSlimVersion, serverVersionNumber));
        }
    }

    @Override
    public void kill() throws IOException {
        if (this.slimRunner != null) {
            this.slimRunner.kill();
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void connect() throws IOException {
        int sleepStep = 50;
        long timeOut = Clock.currentTimeInMillis() + (long)(this.connectionTimeout * 1000);
        LOG.finest("Trying to connect to host: " + this.hostName + " on port: " + this.port + " SSL=" + this.useSSL + " timeout setting: " + this.connectionTimeout);
        while (this.client == null) {
            if (this.slimRunner != null && this.slimRunner.isDead()) {
                String slimErrorMessage = "Error SLiM server died before a connection could be established. " + this.slimRunner.getCommandErrorMessage();
                throw new SlimError(slimErrorMessage);
            }
            try {
                this.client = SocketFactory.createClientSocket(this.hostName, this.port, this.useSSL, this.sslParameterClassName);
            }
            catch (IOException e) {
                if (Clock.currentTimeInMillis() > timeOut) {
                    throw new SlimError("Error connecting to SLiM server on " + this.hostName + ":" + this.port, e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException i) {
                    throw new SlimError("Wait for connection interrupted.");
                }
            }
        }
        LOG.fine("Connected to host: " + this.hostName + " on port: " + this.port + " SSL=" + this.useSSL + " timeout setting: " + this.connectionTimeout);
        this.reader = SlimStreamReader.getReader(this.client);
        this.writer = SlimStreamReader.getByteWriter(this.client);
        this.validateConnection();
    }

    private void validateConnection() throws IOException {
        int waittime = this.connectionTimeout * 1000;
        int oldTimeout = this.client.getSoTimeout();
        this.client.setSoTimeout(waittime);
        try {
            this.slimServerVersionMessage = this.reader.readLine();
        }
        catch (SocketTimeoutException e) {
            throw new SlimError("Timeout while reading slim header from client. Check that you are connecting to the right port and that the slim client is running. You can increase the timeout limit by setting 'slim.timeout' in the fitnesse properties file.");
        }
        finally {
            this.client.setSoTimeout(oldTimeout);
        }
        LOG.finest("Read Slim Header: >" + this.slimServerVersionMessage + "<");
        if (!this.isConnected()) {
            throw new SlimError("Got invalid slim header from client. Read the following: " + this.slimServerVersionMessage);
        }
        try {
            this.slimServerVersion = Double.parseDouble(this.slimServerVersionMessage.replace("Slim -- V", ""));
        }
        catch (Exception e) {
            this.slimServerVersion = -32000.0;
            throw new SlimError("Got invalid slim version from Client. Read the following: " + this.slimServerVersionMessage);
        }
        LOG.fine("Got Slim Header: " + this.slimServerVersionMessage + ", and Version " + this.slimServerVersion);
    }

    public double getServerVersion() {
        return this.slimServerVersion;
    }

    public boolean isConnected() {
        return this.slimServerVersionMessage.startsWith("Slim -- V");
    }

    public String getPeerName() {
        return SocketFactory.peerName(this.client);
    }

    public String getMyName() {
        return SocketFactory.myName(this.client);
    }

    @Override
    public Map<String, Object> invokeAndGetResponse(List<Instruction> statements) throws IOException {
        if (statements.isEmpty()) {
            return Collections.emptyMap();
        }
        String instructions = SlimSerializer.serialize(new SlimListBuilder(this.slimServerVersion).toList(statements));
        SlimStreamReader.sendSlimMessage(this.writer, instructions);
        String results = this.reader.getSlimMessage();
        List<Object> resultList = SlimDeserializer.deserialize(results);
        return SlimCommandRunningClient.resultToMap(resultList);
    }

    @Override
    public void bye() throws IOException {
        SlimStreamReader.sendSlimMessage(this.writer, "bye");
        this.writer.close();
        this.reader.close();
        this.client.close();
        this.slimRunner.join();
        this.kill();
    }

    public static Map<String, Object> resultToMap(List<?> slimResults) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object aResult : slimResults) {
            List resultList = (List)aResult;
            map.put((String)resultList.get(0), resultList.get(1));
        }
        return map;
    }
}

