/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testutil;

import fitnesse.ContextConfigurator;
import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.authentication.Authenticator;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.plugins.PluginException;
import fitnesse.wiki.RecentChangesWikiPage;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wiki.fs.InMemoryPage;
import fitnesse.wiki.fs.ZipFileVersionsController;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import util.FileUtil;

public class FitNesseUtil {
    public static final String base = "RooT";
    public static final int PORT = 1999;
    public static final String URL = "http://localhost:1999/";
    private static FitNesse instance = null;

    public static void startFitnesseWithContext(FitNesseContext context) {
        instance = context.fitNesse;
        instance.start();
    }

    public static void stopFitnesse() throws IOException {
        instance.stop();
        FileUtil.deleteFileSystemDirectory(base);
    }

    public static FitNesseContext makeTestContext() {
        Properties properties = new Properties();
        properties.setProperty("FITNESSE_PORT", String.valueOf(1999));
        return FitNesseUtil.makeTestContext(InMemoryPage.newInstance(), properties);
    }

    public static FitNesseContext makeTestContext(Properties properties) {
        return FitNesseUtil.makeTestContext(InMemoryPage.newInstance(), properties);
    }

    public static FitNesseContext makeTestContext(WikiPageFactory wikiPageFactory, Properties properties) {
        File temporaryFolder = FitNesseUtil.createTemporaryFolder();
        return FitNesseUtil.makeTestContext(wikiPageFactory, temporaryFolder.getPath(), base, 1999, new PromiscuousAuthenticator(), properties);
    }

    public static FitNesseContext makeTestContext(int port) {
        return FitNesseUtil.makeTestContext(InMemoryPage.newInstance(), FitNesseUtil.createTemporaryFolder().getPath(), base, port, new PromiscuousAuthenticator());
    }

    public static FitNesseContext makeTestContext(Authenticator authenticator) {
        return FitNesseUtil.makeTestContext(InMemoryPage.newInstance(), FitNesseUtil.createTemporaryFolder().getPath(), base, 1999, authenticator);
    }

    public static FitNesseContext makeTestContext(FileSystem fileSystem) {
        return FitNesseUtil.makeTestContext(InMemoryPage.newInstance(fileSystem), FitNesseUtil.createTemporaryFolder().getPath(), base, 1999, new PromiscuousAuthenticator());
    }

    public static FitNesseContext makeTestContext(int port, Authenticator authenticator, Properties properties) {
        return FitNesseUtil.makeTestContext(InMemoryPage.newInstance(), FitNesseUtil.createTemporaryFolder().getPath(), base, port, authenticator, properties);
    }

    public static FitNesseContext makeTestContext(WikiPageFactory wikiPageFactory, String rootPath, String name, int port) {
        return FitNesseUtil.makeTestContext(wikiPageFactory, rootPath, name, port, new PromiscuousAuthenticator());
    }

    public static FitNesseContext makeTestContext(WikiPageFactory wikiPageFactory, String rootPath, String rootDirectoryName, int port, Authenticator authenticator) {
        return FitNesseUtil.makeTestContext(wikiPageFactory, rootPath, rootDirectoryName, port, authenticator, new Properties());
    }

    public static FitNesseContext makeTestContext(WikiPageFactory wikiPageFactory, String rootPath, String rootDirectoryName, int port, Authenticator authenticator, Properties properties) {
        FitNesseContext context;
        try {
            context = ContextConfigurator.systemDefaults().withWikiPageFactory(wikiPageFactory).withRootPath(rootPath).withRootDirectoryName(rootDirectoryName).withPort(port).withAuthenticator(authenticator).withVersionsController(new ZipFileVersionsController()).withRecentChanges(new RecentChangesWikiPage()).updatedWith(properties).makeFitNesseContext();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (PluginException e) {
            throw new IllegalStateException(e);
        }
        context.pageFactory.getVelocityEngine();
        return context;
    }

    private static File createTemporaryFolder() {
        File createdFolder;
        try {
            createdFolder = File.createTempFile("fitnesse", "");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temporary folder for test execution", e);
        }
        createdFolder.delete();
        createdFolder.mkdir();
        return createdFolder;
    }

    public static void destroyTestContext(FitNesseContext context) {
        FileUtil.deleteFileSystemDirectory(context.rootPath);
    }

    public static void destroyTestContext() {
        FileUtil.deleteFileSystemDirectory(base);
    }
}

