/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.WikiPage;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WikiPagePath
implements Comparable<Object> {
    private LinkedList<String> names = new LinkedList();
    private Mode mode = Mode.RELATIVE;

    public WikiPagePath() {
    }

    public WikiPagePath(String[] names) {
        for (String name : names) {
            this.addNameToEnd(name);
        }
    }

    public WikiPagePath copy() {
        WikiPagePath clone = new WikiPagePath();
        clone.names = (LinkedList)this.names.clone();
        clone.mode = this.mode;
        return clone;
    }

    public WikiPagePath(WikiPage page) {
        while (!page.isRoot()) {
            this.names.addFirst(page.getName());
            page = page.getParent();
        }
    }

    public WikiPagePath(WikiPagePath path) {
        this.mode = path.mode;
        WikiPagePath p = path;
        while (!p.isEmpty()) {
            this.addNameToEnd(p.getFirst());
            p = p.getRest();
        }
    }

    private WikiPagePath(List<String> names) {
        this.names = new LinkedList<String>(names);
    }

    public String getFirst() {
        return this.isEmpty() ? null : this.names.get(0);
    }

    public WikiPagePath addNameToEnd(String name) {
        this.names.add(name);
        return this;
    }

    public WikiPagePath addNameToFront(String name) {
        this.names.addFirst(name);
        return this;
    }

    public WikiPagePath getRest() {
        int size = this.names.size();
        return size <= 1 ? new WikiPagePath() : new WikiPagePath(this.names.subList(1, size));
    }

    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    public String last() {
        return this.names.isEmpty() ? null : this.names.get(this.names.size() - 1);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String toString() {
        String prefix = "";
        if (this.mode == Mode.ABSOLUTE) {
            prefix = ".";
        } else if (this.mode == Mode.SUB_PAGE) {
            prefix = ">";
        } else if (this.mode == Mode.BACKWARD_SEARCH) {
            prefix = "<";
        }
        return prefix + StringUtils.join(this.names, (String)".");
    }

    public void removeNameFromEnd() {
        if (!this.names.isEmpty()) {
            this.names.removeLast();
        }
    }

    public WikiPagePath append(WikiPagePath childPath) {
        WikiPagePath newPath = new WikiPagePath(this);
        WikiPagePath p = childPath;
        while (!p.isEmpty()) {
            newPath.addNameToEnd(p.getFirst());
            p = p.getRest();
        }
        return newPath;
    }

    public boolean isAbsolute() {
        return this.mode == Mode.ABSOLUTE;
    }

    public void makeAbsolute() {
        this.mode = Mode.ABSOLUTE;
    }

    public int hashCode() {
        return StringUtils.join(this.names, (String)"").hashCode();
    }

    public WikiPagePath relativePath() {
        if (this.isAbsolute() && !this.isEmpty()) {
            WikiPagePath relativePath = new WikiPagePath(this);
            relativePath.setPathMode(Mode.RELATIVE);
            return relativePath;
        }
        return this;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof WikiPagePath) {
            WikiPagePath p = (WikiPagePath)o;
            String compressedName = StringUtils.join(this.names, (String)"");
            String compressedArgumentName = StringUtils.join(p.names, (String)"");
            return compressedName.compareTo(compressedArgumentName);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof WikiPagePath) {
            WikiPagePath that = (WikiPagePath)o;
            return this.mode == that.mode && this.names.equals(that.names);
        }
        return false;
    }

    public WikiPagePath parentPath() {
        WikiPagePath parentPath = new WikiPagePath(this);
        parentPath.removeNameFromEnd();
        return parentPath;
    }

    public boolean startsWith(WikiPagePath that) {
        if (that.names.size() > this.names.size()) {
            return false;
        }
        Iterator thisIterator = this.names.iterator();
        for (String name : that.names) {
            Object thisNext = thisIterator.next();
            if (thisNext.equals(name)) continue;
            return false;
        }
        return true;
    }

    public WikiPagePath withNameAdded(String name) {
        WikiPagePath path = new WikiPagePath(this);
        path.addNameToEnd(name);
        return path;
    }

    public WikiPagePath subtractFromFront(WikiPagePath operand) {
        WikiPagePath difference = new WikiPagePath(this);
        if (difference.startsWith(operand)) {
            difference.setPathMode(Mode.RELATIVE);
            for (String name : operand.getNames()) {
                if (!name.equals(difference.getFirst())) break;
                difference.names.removeFirst();
            }
        }
        return difference;
    }

    public void setPathMode(Mode mode) {
        this.mode = mode;
    }

    public boolean isRelativePath() {
        return this.mode == Mode.RELATIVE;
    }

    public boolean isSubPagePath() {
        return this.mode == Mode.SUB_PAGE;
    }

    public boolean isBackwardSearchPath() {
        return this.mode == Mode.BACKWARD_SEARCH;
    }

    public static enum Mode {
        ABSOLUTE,
        SUB_PAGE,
        BACKWARD_SEARCH,
        RELATIVE;

    }
}

