/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fit.FixtureLoader;
import fit.FixtureName;
import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.DynamicDecisionTable;
import fitnesse.testsystems.slim.tables.ImportTable;
import fitnesse.testsystems.slim.tables.QueryTable;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.HtmlWriter;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.SymbolTypeDecorator;
import fitnesse.wikitext.parser.Table;
import fitnesse.wikitext.parser.Translator;
import java.util.List;

public class ColoredSlimTable
extends SymbolTypeDecorator {
    public static final String CLASS_PROPERTY = "class";

    public ColoredSlimTable(Table baseSymbolType) {
        super("Table", baseSymbolType);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("table");
        if (symbol.hasProperty(CLASS_PROPERTY)) {
            writer.putAttribute(CLASS_PROPERTY, symbol.getProperty(CLASS_PROPERTY));
        }
        int longestRow = ((Table)this.baseSymbolType).longestRow(symbol);
        int rowCount = 0;
        boolean isImportFixture = false;
        boolean colorTable = false;
        boolean isFirstColumnTitle = false;
        boolean isSecondRowTitle = false;
        for (Symbol child : symbol.getChildren()) {
            writer.startTag("tr");
            if (++rowCount == 1 && symbol.hasProperty("hideFirst")) {
                writer.putAttribute(CLASS_PROPERTY, "hidden");
            }
            int extraColumnSpan = longestRow - ((Table)this.baseSymbolType).rowLength(child);
            int column = 1;
            for (Symbol grandChild : child.getChildren()) {
                String body = ((Table)this.baseSymbolType).translateCellBody(translator, grandChild);
                if (rowCount == 1 && column == 1) {
                    SlimTableFactory sf = new SlimTableFactory();
                    String tableName = body;
                    Class<? extends SlimTable> slimTableClazz = sf.getTableType(tableName);
                    if (slimTableClazz != null) {
                        colorTable = true;
                        if (DecisionTable.class.isAssignableFrom(slimTableClazz) || DynamicDecisionTable.class.isAssignableFrom(slimTableClazz) || QueryTable.class.isAssignableFrom(slimTableClazz)) {
                            isSecondRowTitle = true;
                        } else if (ImportTable.class.isAssignableFrom(slimTableClazz)) {
                            isImportFixture = true;
                        } else if (ScriptTable.class.isAssignableFrom(slimTableClazz) || ScenarioTable.class.isAssignableFrom(slimTableClazz)) {
                            isFirstColumnTitle = true;
                        }
                    }
                    if (!colorTable) {
                        List<String> potentialClasses = new FixtureName(tableName).getPotentialFixtureClassNames(FixtureLoader.instance().fixturePathElements);
                        for (String potentialClass : potentialClasses) {
                            if (!this.isValidClass(potentialClass)) continue;
                            colorTable = true;
                            isSecondRowTitle = true;
                            break;
                        }
                    }
                }
                if (colorTable && column == 1) {
                    if (isImportFixture) {
                        FixtureLoader.instance().addPackageToPath(body);
                    }
                    if (rowCount == 1) {
                        writer.putAttribute(CLASS_PROPERTY, "slimRowTitle");
                    } else if (isSecondRowTitle && rowCount == 2) {
                        writer.putAttribute(CLASS_PROPERTY, "slimRowTitle");
                    } else if (isFirstColumnTitle) {
                        byte[] bodyBytes = body.getBytes();
                        int sum = 0;
                        for (byte b : bodyBytes) {
                            sum += b;
                        }
                        writer.putAttribute(CLASS_PROPERTY, "slimRowColor" + sum % 10);
                    } else {
                        writer.putAttribute(CLASS_PROPERTY, "slimRowColor" + rowCount % 2);
                    }
                }
                writer.startTag("td");
                if (extraColumnSpan > 0 && column == ((Table)this.baseSymbolType).rowLength(child)) {
                    writer.putAttribute("colspan", Integer.toString(extraColumnSpan + 1));
                }
                writer.putText(body);
                writer.endTag();
                ++column;
            }
            writer.endTag();
        }
        writer.endTag();
        return writer.toHtml();
    }

    private boolean isValidClass(String potentialClass) {
        try {
            return Class.forName(potentialClass) != null;
        }
        catch (Exception e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public SymbolType isApplicable(Translator translator) {
        Maybe<String> testSystem = Maybe.noString;
        if (translator instanceof HtmlTranslator) {
            testSystem = ((HtmlTranslator)translator).getParsingPage().findVariable("TEST_SYSTEM");
        }
        if (testSystem.isNothing() || !"slim".equals(testSystem.getValue())) {
            return this.baseSymbolType;
        }
        return this;
    }
}

