/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.CompositeVariableSource;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.VariableSource;
import java.util.HashMap;
import java.util.Map;

public class ParsingPage
implements VariableSource {
    private final SourcePage page;
    private final SourcePage namedPage;
    private final VariableSource variableSource;
    private final Cache cache;

    public ParsingPage(SourcePage page) {
        this(page, new Cache());
    }

    private ParsingPage(SourcePage page, Cache cache) {
        this(page, page, cache, cache);
    }

    public ParsingPage(SourcePage page, VariableSource variableSource, Cache cache) {
        this(page, page, variableSource, cache);
    }

    private ParsingPage(SourcePage page, SourcePage namedPage, VariableSource variableSource, Cache cache) {
        this.page = page;
        this.namedPage = namedPage;
        this.variableSource = new CompositeVariableSource(new NamedPageVariableSource(namedPage), variableSource);
        this.cache = cache;
    }

    public ParsingPage copyForNamedPage(SourcePage namedPage) {
        return new ParsingPage(this.page, namedPage, this.variableSource, this.cache);
    }

    public SourcePage getPage() {
        return this.page;
    }

    public SourcePage getNamedPage() {
        return this.namedPage;
    }

    public void putVariable(String name, String value) {
        this.cache.putVariable(name, new Maybe<String>(value));
    }

    @Override
    public Maybe<String> findVariable(String name) {
        return this.variableSource != null ? this.variableSource.findVariable(name) : Maybe.noString;
    }

    private static class NamedPageVariableSource
    implements VariableSource {
        private final SourcePage namedPage;

        private NamedPageVariableSource(SourcePage namedPage) {
            this.namedPage = namedPage;
        }

        @Override
        public Maybe<String> findVariable(String key) {
            String value;
            if (key.equals("PAGE_NAME")) {
                value = this.namedPage.getName();
            } else if (key.equals("PAGE_PATH")) {
                value = this.namedPage.getPath();
            } else {
                return Maybe.noString;
            }
            return new Maybe<String>(value);
        }
    }

    public static class Cache
    implements VariableSource {
        private final Map<String, Maybe<String>> cache;

        public Cache() {
            this(new HashMap<String, Maybe<String>>());
        }

        public Cache(Map<String, Maybe<String>> cache) {
            this.cache = cache;
        }

        public void putVariable(String name, Maybe<String> value) {
            this.cache.put(name, value);
        }

        @Override
        public Maybe<String> findVariable(String name) {
            if (!this.cache.containsKey(name)) {
                return Maybe.noString;
            }
            return this.cache.get(name);
        }
    }
}

