/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.HeaderLine;
import fitnesse.wikitext.parser.HorizontalRule;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Nesting;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Table;
import fitnesse.wikitext.parser.VariableSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Symbol {
    private static final List<Symbol> NO_CHILDREN = Collections.emptyList();
    public static final Maybe<Symbol> nothing = new Maybe();
    public static final Symbol emptySymbol = new Symbol(SymbolType.Empty);
    private SymbolType type;
    private String content;
    private List<Symbol> children;
    private Map<String, String> variables;
    private Map<String, String> properties;
    private int startOffset = -1;
    private int endOffset = -1;

    public Symbol(SymbolType type) {
        this(type, "");
    }

    public Symbol(SymbolType type, String content) {
        this.type = type;
        this.content = content;
        this.children = NO_CHILDREN;
    }

    public Symbol(SymbolType type, String content, int startOffset) {
        this(type, content);
        this.startOffset = startOffset;
        this.endOffset = startOffset + content.length();
    }

    public Symbol(SymbolType type, String content, int startOffset, int endOffset) {
        this(type, content);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public SymbolType getType() {
        return this.type;
    }

    public boolean isType(SymbolType type) {
        return this.type.matchesFor(type);
    }

    public boolean isStartCell() {
        return this.isType(Table.symbolType) || this.isType(SymbolType.EndCell);
    }

    public boolean isStartLine() {
        return this.isType(HorizontalRule.symbolType) || this.isType(Nesting.symbolType);
    }

    public boolean isLineType() {
        return this.isType(HeaderLine.symbolType) || this.isType(SymbolType.CenterLine) || this.isType(SymbolType.Meta) || this.isType(SymbolType.NoteLine);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Symbol childAt(int index) {
        return this.getChildren().get(index);
    }

    public Symbol lastChild() {
        return this.childAt(this.getChildren().size() - 1);
    }

    public List<Symbol> getChildren() {
        return this.children;
    }

    private List<Symbol> children() {
        if (this.children == NO_CHILDREN) {
            this.children = new LinkedList<Symbol>();
        }
        return this.children;
    }

    public Symbol addToFront(Symbol child) {
        this.children().add(0, child);
        return this;
    }

    public Symbol add(Symbol child) {
        this.children().add(child);
        return this;
    }

    public Symbol add(String text) {
        this.children().add(new Symbol(SymbolType.Text, text));
        return this;
    }

    public Symbol childrenAfter(int after) {
        Symbol result = new Symbol(SymbolType.SymbolList);
        for (int i = after + 1; i < this.children.size(); ++i) {
            result.add(this.children.get(i));
        }
        return result;
    }

    public boolean walkPostOrder(SymbolTreeWalker walker) {
        if (walker.visitChildren(this)) {
            for (Symbol child : this.children) {
                if (child.walkPostOrder(walker)) continue;
                return false;
            }
        }
        return walker.visit(this);
    }

    public boolean walkPreOrder(SymbolTreeWalker walker) {
        if (!walker.visit(this)) {
            return false;
        }
        if (walker.visitChildren(this)) {
            for (Symbol child : this.children) {
                if (child.walkPreOrder(walker)) continue;
                return false;
            }
        }
        return true;
    }

    public void evaluateVariables(String[] names, VariableSource source) {
        if (this.variables == null) {
            this.variables = new HashMap<String, String>(names.length);
        }
        for (String name : names) {
            Maybe<String> value = source.findVariable(name);
            if (value.isNothing()) continue;
            this.variables.put(name, value.getValue());
        }
    }

    public String getVariable(String name, String defaultValue) {
        return this.variables != null && this.variables.containsKey(name) ? this.variables.get(name) : defaultValue;
    }

    public Symbol putProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>(1);
        }
        this.properties.put(key, value);
        return this;
    }

    public boolean hasProperty(String key) {
        return this.properties != null && this.properties.containsKey(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties != null && this.properties.containsKey(key) ? this.properties.get(key) : defaultValue;
    }

    public String getProperty(String key) {
        return this.getProperty(key, "");
    }

    public boolean hasOffset() {
        return this.startOffset != -1 && this.endOffset != -1;
    }

    Symbol setStartOffset(int startOffset) {
        this.startOffset = startOffset;
        return this;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    Symbol setEndOffset(int endOffset) {
        this.endOffset = endOffset;
        return this;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setType(SymbolType type) {
        this.type = type;
    }
}

