/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.unicode;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;

public enum BOM {
    NONE("NONE", new byte[0], null),
    UTF8("UTF-8", new byte[]{-17, -69, -65}, Charsets.UTF_8),
    UTF16BE("UTF-16BE", new byte[]{-2, -1}, Charsets.UTF_16BE),
    UTF16LE("UTF-16LE", new byte[]{-1, -2}, Charsets.UTF_16LE);

    private final String name;
    private final byte[] bom;
    private Charset charset;

    private BOM(String encoding, byte[] bom, Charset charset) {
        this.name = encoding;
        this.bom = bom;
        this.charset = charset;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultCharset() {
        return this.charset == null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getSize() {
        return this.bom.length;
    }

    public byte[] getBom() {
        return (byte[])this.bom.clone();
    }

    public String toString() {
        return this.name;
    }
}

