/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.semver;

import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.util.Stream;
import com.github.zafarkhaja.semver.util.UnexpectedElementException;
import com.xebialabs.deployit.plugin.api.semver.Lexer;
import java.util.function.Predicate;

public class VersionRange {
    private boolean rightClosed;
    private Version leftVersion;
    private Version rightVersion;
    private boolean leftClosed;

    public static VersionRange withDefaultLexer(String range) {
        return new VersionRange(range);
    }

    public VersionRange(String range) {
        this(new Lexer(), range);
    }

    public VersionRange(Lexer lexer, String range) {
        Stream<Lexer.Token> tokens = lexer.tokenize(range);
        this.leftClosed = tokens.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.LEFT_CLOSED});
        boolean leftOpen = tokens.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.LEFT_OPEN});
        if (!this.leftClosed && !leftOpen) {
            this.leftClosed = true;
            this.rightClosed = false;
            this.leftVersion = this.parseVersion(range);
            return;
        }
        Lexer.Token startToken = this.leftClosed ? this.consumeNextToken(tokens, Lexer.Token.Type.LEFT_CLOSED) : this.consumeNextToken(tokens, Lexer.Token.Type.LEFT_OPEN);
        this.leftVersion = this.extractVersion(tokens, tokenStream -> !tokenStream.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.COMMA}));
        this.consumeNextToken(tokens, Lexer.Token.Type.COMMA);
        this.rightVersion = this.extractVersion(tokens, tokenStream -> !tokenStream.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.RIGHT_CLOSED}) && !tokenStream.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.RIGHT_OPEN}));
        this.rightClosed = tokens.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.RIGHT_CLOSED});
        Lexer.Token endToken = this.rightClosed ? this.consumeNextToken(tokens, Lexer.Token.Type.RIGHT_CLOSED) : this.consumeNextToken(tokens, Lexer.Token.Type.RIGHT_OPEN);
    }

    private Version extractVersion(Stream<Lexer.Token> tokens, Predicate<Stream<Lexer.Token>> predicate) {
        StringBuilder versionBuilder = new StringBuilder();
        while (predicate.test(tokens)) {
            versionBuilder.append(((Lexer.Token)tokens.consume()).getLexeme());
        }
        return this.parseVersion(versionBuilder.toString());
    }

    private Version parseVersion(String version) {
        String[] parts = version.trim().split("\\.");
        if (parts.length == 1) {
            return Version.forIntegers((int)Integer.parseInt(parts[0]));
        }
        if (parts.length == 2) {
            return Version.forIntegers((int)Integer.parseInt(parts[0]), (int)Integer.parseInt(parts[1]));
        }
        return Version.valueOf((String)version);
    }

    public boolean includes(Version version) {
        return this.leftVersion.compareTo(version) < (this.leftClosed ? 1 : 0) && (this.rightVersion == null || this.rightVersion.compareTo(version) >= (this.rightClosed ? 0 : 1));
    }

    private Lexer.Token consumeNextToken(Stream<Lexer.Token> tokens, Lexer.Token.Type ... expected) {
        try {
            return (Lexer.Token)tokens.consume((Stream.ElementType[])expected);
        }
        catch (UnexpectedElementException e) {
            throw new RuntimeException(e);
        }
    }
}

