/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.SearchParameters;
import com.xebialabs.deployit.plugin.api.udm.CandidateValuesFilter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Metadata(description="A deployment of an application package or a deployable artifact to a middleware CI or an environment.")
@PublicApiRef
public class DeployedApplication
extends BaseConfigurationItem {
    private static final String VERSION_CANDIDATE_FILTER = "deployedApplicationVersionCandidateFilter";
    @Property(description="The package that has been deployed to the environment", candidateValuesFilter="deployedApplicationVersionCandidateFilter")
    private Version version;
    @Property(asContainment=true)
    private Environment environment;
    @Property(description="The deployed items that have been deployed to the environment")
    private Set<Deployed> deployeds = new HashSet<Deployed>();
    @Property(description="The orchestrators that are used to create the deployment plan. Orchestrators will be applied in order.", required=false)
    private List<String> orchestrator;
    @Property(description="Whether to optimize the generated plan after orchestration", required=false, defaultValue="true")
    private boolean optimizePlan;

    public DeployedApplication() {
    }

    public DeployedApplication(Version version, Environment environment) {
        this.version = version;
        this.environment = environment;
    }

    @CandidateValuesFilter(name="deployedApplicationVersionCandidateFilter")
    public static SearchParameters findApplicationVersions(ConfigurationItem context, PropertyDescriptor property) {
        DeployedApplication da = (DeployedApplication)context;
        SearchParameters params = new SearchParameters();
        params.setType(property.getReferencedType());
        Version version = da.getVersion();
        if (version != null) {
            params.setParent(version.getApplication().getId());
        }
        return params;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Set<Deployed> getDeployeds() {
        return this.deployeds;
    }

    public void setDeployeds(Set<Deployed> deployeds) {
        this.deployeds = deployeds;
    }

    public void addDeployed(Deployed deployed) {
        this.deployeds.add(deployed);
    }

    public void addDeployeds(Deployed ... deployeds) {
        this.deployeds.addAll(Arrays.asList(deployeds));
    }

    public void addDeployeds(Collection<Deployed> deployeds) {
        this.deployeds.addAll(deployeds);
    }

    public List<String> getOrchestrator() {
        return this.orchestrator;
    }

    public void setOrchestrator(List<String> orchestrator) {
        this.orchestrator = orchestrator;
    }

    public boolean isOptimizePlan() {
        return this.optimizePlan;
    }

    public void setOptimizePlan(boolean optimizePlan) {
        this.optimizePlan = optimizePlan;
    }
}

