/*
 * Decompiled with CFR 0.152.
 */
package scalax.io;

import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Either;
import scalax.io.ResourceContext;
import scalax.io.ResourceContext$;
import scalax.io.ResourceContext$$anon$1$;
import scalax.io.ResourceDescName;
import scalax.io.ScalaIOException;
import scalax.io.UnknownName;

public abstract class ResourceContext$class {
    public static Throwable openErrorHandler(ResourceContext $this, Throwable openException) {
        throw openException;
    }

    public static Object errorHandler(ResourceContext $this, Either accessResult, List closingExceptions) {
        throw new ScalaIOException((Option<Throwable>)accessResult.left().toOption(), (List<Throwable>)closingExceptions);
    }

    public static ResourceDescName descName(ResourceContext $this) {
        return new UnknownName();
    }

    public static int byteBufferSize(ResourceContext $this, Option dataSize, boolean readOnly) {
        int n;
        Some some;
        if (dataSize instanceof Some && BoxesRunTime.unboxToLong((Object)(some = (Some)dataSize).x()) > 0L && readOnly) {
            long l = BoxesRunTime.unboxToLong((Object)some.x());
            Predef$ predef$ = Predef$.MODULE$;
            n = (int)RichLong$.MODULE$.min$extension(l, 4096L);
        } else {
            n = 4096;
        }
        return n;
    }

    public static int charBufferSize(ResourceContext $this, Option dataSize, boolean readOnly) {
        int n;
        Some some;
        if (dataSize instanceof Some && BoxesRunTime.unboxToInt((Object)(some = (Some)dataSize).x()) > 0 && readOnly) {
            int n2 = BoxesRunTime.unboxToInt((Object)some.x());
            Predef$ predef$ = Predef$.MODULE$;
            n = RichInt$.MODULE$.min$extension(n2, 1024);
        } else {
            n = 1024;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ByteBuffer createNioBuffer(ResourceContext $this, int bufferSize, Option channel, boolean readOnly) {
        if (!(channel instanceof Some)) return ByteBuffer.allocateDirect(bufferSize);
        Some some = (Some)channel;
        if (!(some.x() instanceof FileChannel)) return ByteBuffer.allocateDirect(bufferSize);
        FileChannel fileChannel = (FileChannel)some.x();
        if (!readOnly) return ByteBuffer.allocateDirect(bufferSize);
        if (fileChannel.size() > (long)bufferSize) return ByteBuffer.allocateDirect(bufferSize);
        return fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
    }

    public static final ByteBuffer createNioBuffer(ResourceContext $this, Option dataSize, Option channel, boolean readOnly) {
        return $this.createNioBuffer($this.byteBufferSize((Option<Object>)dataSize, readOnly), (Option<Channel>)channel, readOnly);
    }

    public static ResourceContext copy(ResourceContext $this, Option newByteBufferSize, Option newCharBufferSize, Option newCreateNioBuffer, Option newOpenErrorHandler, Option newErrorHandler, Option newDescName) {
        return new ResourceContext($this, newByteBufferSize, newCharBufferSize, newCreateNioBuffer, newOpenErrorHandler, newErrorHandler, newDescName){
            public final /* synthetic */ ResourceContext $outer;
            private final Option newByteBufferSize$1;
            private final Option newCharBufferSize$1;
            private final Option newCreateNioBuffer$1;
            private final Option newOpenErrorHandler$1;
            private final Option newErrorHandler$1;
            private final Option newDescName$1;

            public final int recommendedByteBufferSize() {
                return 4096;
            }

            public final int recommendedCharBufferSize() {
                return 1024;
            }

            public final ByteBuffer createNioBuffer(Option<Object> dataSize, Option<Channel> channel, boolean readOnly) {
                return ResourceContext$class.createNioBuffer((ResourceContext)this, dataSize, channel, readOnly);
            }

            public <U> Object copy(Option<Function2<Option<Object>, Object, Object>> newByteBufferSize, Option<Function2<Option<Object>, Object, Object>> newCharBufferSize, Option<Function3<Object, Option<Channel>, Object, ByteBuffer>> newCreateNioBuffer, Option<Function1<Throwable, Throwable>> newOpenErrorHandler, Option<Function2<Either<Throwable, U>, List<Throwable>, U>> newErrorHandler, Option<ResourceDescName> newDescName) {
                return ResourceContext$class.copy(this, newByteBufferSize, newCharBufferSize, newCreateNioBuffer, newOpenErrorHandler, newErrorHandler, newDescName);
            }

            public <U> Option<Function2<Option<Object>, Object, Object>> copy$default$1() {
                return ResourceContext$class.copy$default$1(this);
            }

            public <U> Option<Function2<Option<Object>, Object, Object>> copy$default$2() {
                return ResourceContext$class.copy$default$2(this);
            }

            public <U> Option<Function3<Object, Option<Channel>, Object, ByteBuffer>> copy$default$3() {
                return ResourceContext$class.copy$default$3(this);
            }

            public <U> Option<Function1<Throwable, Throwable>> copy$default$4() {
                return ResourceContext$class.copy$default$4(this);
            }

            public <U> None$ copy$default$5() {
                return ResourceContext$class.copy$default$5(this);
            }

            public <U> Option<ResourceDescName> copy$default$6() {
                return ResourceContext$class.copy$default$6(this);
            }

            public <U2> U2 errorHandler(Either<Throwable, U2> accessResult, List<Throwable> closingExceptions) {
                Option option;
                block4: {
                    Object object;
                    block3: {
                        block2: {
                            option = this.newErrorHandler$1;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            object = ((Function2)some.x()).apply(accessResult, closingExceptions);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        object = this.$outer.errorHandler(accessResult, closingExceptions);
                    }
                    return (U2)object;
                }
                throw new MatchError((Object)option);
            }

            public Throwable openErrorHandler(Throwable openException) {
                Option option;
                block4: {
                    Throwable throwable;
                    block3: {
                        block2: {
                            option = this.newOpenErrorHandler$1;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            throwable = (Throwable)((Function1)some.x()).apply((Object)openException);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        throwable = this.$outer.openErrorHandler(openException);
                    }
                    return throwable;
                }
                throw new MatchError((Object)option);
            }

            public ResourceDescName descName() {
                Option option = this.newDescName$1;
                return (ResourceDescName)(!option.isEmpty() ? option.get() : this.$outer.descName());
            }

            public int byteBufferSize(Option<Object> dataSize, boolean readOnly) {
                Serializable serializable = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ ResourceContext$.anon.1 $outer;

                    public final Function2<Option<Object>, Object, Object> apply() {
                        return new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ResourceContext$$anon$1$.anonfun.byteBufferSize.1 $outer;

                            public final int apply(Option<Object> dataSize, boolean readOnly) {
                                return this.$outer.$outer.scalax$io$ResourceContext$$anon$$$outer().byteBufferSize(dataSize, readOnly);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                    }

                    public /* synthetic */ ResourceContext$.anon.1 scalax$io$ResourceContext$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                Option option = this.newByteBufferSize$1;
                return BoxesRunTime.unboxToInt((Object)((Function2)(!option.isEmpty() ? option.get() : new /* invalid duplicate definition of identical inner class */)).apply(dataSize, (Object)BoxesRunTime.boxToBoolean((boolean)readOnly)));
            }

            public int charBufferSize(Option<Object> dataSize, boolean readOnly) {
                Serializable serializable = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ ResourceContext$.anon.1 $outer;

                    public final Function2<Option<Object>, Object, Object> apply() {
                        return new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ResourceContext$$anon$1$.anonfun.charBufferSize.1 $outer;

                            public final int apply(Option<Object> dataSize, boolean readOnly) {
                                return this.$outer.$outer.scalax$io$ResourceContext$$anon$$$outer().charBufferSize(dataSize, readOnly);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        };
                    }

                    public /* synthetic */ ResourceContext$.anon.1 scalax$io$ResourceContext$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                Option option = this.newCharBufferSize$1;
                return BoxesRunTime.unboxToInt((Object)((Function2)(!option.isEmpty() ? option.get() : new /* invalid duplicate definition of identical inner class */)).apply(dataSize, (Object)BoxesRunTime.boxToBoolean((boolean)readOnly)));
            }

            public ByteBuffer createNioBuffer(int bufferSize, Option<Channel> channel, boolean readOnly) {
                Option option = this.newCreateNioBuffer$1;
                None$ none$ = !option.isEmpty() ? new Some((Object)((ByteBuffer)((Function3)option.get()).apply((Object)BoxesRunTime.boxToInteger((int)bufferSize), channel, (Object)BoxesRunTime.boxToBoolean((boolean)readOnly)))) : None$.MODULE$;
                return (ByteBuffer)(!none$.isEmpty() ? none$.get() : this.$outer.createNioBuffer(bufferSize, channel, readOnly));
            }

            public /* synthetic */ ResourceContext scalax$io$ResourceContext$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newByteBufferSize$1 = newByteBufferSize$1;
                this.newCharBufferSize$1 = newCharBufferSize$1;
                this.newCreateNioBuffer$1 = newCreateNioBuffer$1;
                this.newOpenErrorHandler$1 = newOpenErrorHandler$1;
                this.newErrorHandler$1 = newErrorHandler$1;
                this.newDescName$1 = newDescName$1;
                ResourceContext$class.$init$(this);
            }
        };
    }

    public static Option copy$default$1(ResourceContext $this) {
        return None$.MODULE$;
    }

    public static Option copy$default$2(ResourceContext $this) {
        return None$.MODULE$;
    }

    public static Option copy$default$3(ResourceContext $this) {
        return None$.MODULE$;
    }

    public static Option copy$default$4(ResourceContext $this) {
        return None$.MODULE$;
    }

    public static None$ copy$default$5(ResourceContext $this) {
        return None$.MODULE$;
    }

    public static Option copy$default$6(ResourceContext $this) {
        return None$.MODULE$;
    }

    public static void $init$(ResourceContext $this) {
    }
}

