/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.dto.ServerPluginInfo;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;

public class ServerInfoProvider {
    public static ServerInfo provide() {
        ClassPathResource resource = new ClassPathResource("com/xebialabs/xltest/release.properties");
        Properties release = new Properties();
        try {
            release.load(resource.getInputStream());
            ServerInfo si = new ServerInfo();
            si.setVersion(release.getProperty("version"));
            for (String plugin : PluginVersions.getRegisteredPlugins()) {
                si.getPluginsInfo().add(new ServerPluginInfo(plugin, PluginVersions.getVersionFor((String)plugin)));
            }
            si.setClasspathEntries(ServerInfoProvider.getServerClassPath());
            return si;
        }
        catch (IOException e) {
            throw new DeployitException((Throwable)e);
        }
    }

    private static List<String> getServerClassPath() {
        String classpath = System.getProperty("java.class.path");
        return Lists.newArrayList((Object[])classpath.split(System.getProperty("path.separator")));
    }
}

