/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.v1;

import com.xebialabs.xltest.api.v1.dto.TestSpecificationRequest;
import com.xebialabs.xltest.api.v1.dto.TestSpecificationResponse;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.service.TestSpecificationService;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/v1/projects")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class TestSpecificationController {
    private final TestSpecificationService testSpecificationService;

    @Autowired
    public TestSpecificationController(TestSpecificationService testSpecificationService) {
        this.testSpecificationService = testSpecificationService;
    }

    @POST
    @Path(value="/{projectId}/testspecifications")
    public Response createTestSpecificationForProject(@PathParam(value="projectId") String projectId, TestSpecificationRequest request) throws URISyntaxException {
        BaseTestSpecification newSpec = this.testSpecificationService.createPassiveTestSpecification(projectId, request);
        TestSpecificationResponse response = TestSpecificationResponse.createFrom(newSpec);
        return Response.status((int)201).header("ETag", (Object)newSpec.get$token()).entity((Object)response).location(new URI(String.format("%s/projects/%s/testspecifications/%s", "/api/v1", projectId, newSpec.getName()))).build();
    }

    @GET
    @Path(value="/{projectId}/testspecifications")
    public Response getTestSpecificationsStatusesForProject(@PathParam(value="projectId") String projectId, @QueryParam(value="title") String title) throws JSONException {
        return Response.status((int)200).entity(this.testSpecificationService.getTestSpecifications(projectId, title)).build();
    }

    @GET
    @Path(value="/{projectId}/testspecifications/{testSpecificationId}")
    public Response getTestSpecification(@PathParam(value="projectId") String projectId, @PathParam(value="testSpecificationId") String testSpecificationId) throws JSONException {
        BaseTestSpecification testSpec = this.testSpecificationService.getSpecificationForProject(projectId, testSpecificationId);
        return Response.status((int)200).header("ETag", (Object)testSpec.get$token()).entity((Object)TestSpecificationResponse.createFrom(testSpec)).build();
    }

    @DELETE
    @Path(value="/{projectId}/testspecifications/{testSpecificationId}")
    public Response deleteTestSpecification(@PathParam(value="projectId") String projectId, @PathParam(value="testSpecificationId") String testSpecificationId, @QueryParam(value="force") boolean force, @HeaderParam(value="ETag") String eTag) {
        this.testSpecificationService.deleteTestSpecification(projectId, testSpecificationId, force, eTag);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/{projectId}/testspecifications/{testSpecificationId}")
    public Response updateSpecificationForProject(@PathParam(value="projectId") String projectId, @PathParam(value="testSpecificationId") String testSpecificationId, @HeaderParam(value="ETag") String eTag, TestSpecificationRequest request) throws URISyntaxException {
        BaseTestSpecification newSpec = this.testSpecificationService.updateTestSpecification(projectId, testSpecificationId, request, eTag);
        TestSpecificationResponse response = TestSpecificationResponse.createFrom(newSpec);
        return Response.status((int)200).header("ETag", (Object)newSpec.get$token()).entity((Object)response).location(new URI(String.format("%s/projects/%s/testspecifications/%s", "/api/v1", projectId, newSpec.getName()))).build();
    }

    @Path(value="/{projectId}/testspecifications/{testSpecificationId}/qualifications")
    @GET
    public Response getQualificationByName(@PathParam(value="testSpecificationId") String testSpecification) {
        return this.testSpecificationService.getQualificationForTestSpec(testSpecification);
    }
}

