/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.xebialabs.xltest.serialize.BasicMessageBodyWriter;
import com.xebialabs.xltest.view.ExecutionParameterRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class ExecutionParameterRequestWriter
extends BasicMessageBodyWriter<ExecutionParameterRequest> {
    @Override
    protected void writeJson(ExecutionParameterRequest executionParameterRequest, JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("hostId").value((Object)executionParameterRequest.getHostId());
        writer.key("commandLine").value((Object)executionParameterRequest.getCommandLine());
        writer.key("parameters");
        writer.array();
        for (Map.Entry<String, Set<String>> parameter : executionParameterRequest.getParameters().entrySet()) {
            this.writeJson(parameter.getKey(), parameter.getValue(), writer);
        }
        writer.endArray();
        writer.endObject();
    }

    private void writeJson(String name, Set<String> values, JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("name").value((Object)name);
        writer.key("values");
        writer.array();
        for (String eachValue : values) {
            writer.value((Object)eachValue);
        }
        writer.endArray();
        writer.key("value").value((Object)this.getValue(values));
        writer.endObject();
    }

    public String getValue(Set<String> values) {
        return values.size() == 1 ? values.iterator().next() : "";
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ExecutionParameterRequest.class.isAssignableFrom(type);
    }
}

