/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xltest.api.v1.dto.QualificationResponse;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class QualificationService {
    public List<QualificationResponse> getAllQualifications() {
        String genericQualification = "xlt.Qualification";
        Descriptor genericQualificationDescriptor = DescriptorRegistry.getDescriptor((String)genericQualification);
        Collection subtypes = DescriptorRegistry.getSubtypes((Type)genericQualificationDescriptor.getType());
        List qualificationNames = subtypes.stream().filter(eachQualificationType -> !eachQualificationType.getDescriptor().isVirtual()).filter(this.filterForQualifications()).map(eachQualificationType -> eachQualificationType.toString()).collect(Collectors.toList());
        List<QualificationResponse> qualificationList = qualificationNames.stream().map(qualName -> this.generateResponse((String)qualName)).collect(Collectors.toList());
        return qualificationList;
    }

    public QualificationResponse generateResponse(String name) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)name);
        return new QualificationResponse(descriptor.getType().toString(), descriptor.getDescription(), (Collection)descriptor.getPropertyDescriptor("applicableCategories").getDefaultValue(), descriptor.getLabel());
    }

    private Predicate<Type> filterForQualifications() {
        return eachQualificationType -> {
            PropertyDescriptor propertyDescriptor = eachQualificationType.getDescriptor().getPropertyDescriptor("applicableCategories");
            Object defaultValue = propertyDescriptor.getDefaultValue();
            return defaultValue instanceof Collection;
        };
    }
}

