/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service.execution;

import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.resultparser.NothingToImportException;
import com.xebialabs.xlt.plugin.api.resultparser.UnexpectedFormatException;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.testrun.TestRunNotImportedInChronologicalOrderException;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.domain.ExecutableTestSpecification;
import com.xebialabs.xltest.domain.TestSpecificationSet;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.service.ExecutableAlreadyRunningException;
import com.xebialabs.xltest.service.ImportService;
import com.xebialabs.xltest.service.TestExecutionStateHolder;
import com.xebialabs.xltest.service.execution.TestSpecificationCallable;
import com.xebialabs.xltest.service.execution.TestSpecificationExecutionException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestSpecificationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificationExecutor.class);
    private final ExecutorService executorService;
    private final ImportService importService;
    private final EventRepository eventRepository;
    private final TestExecutionStateHolder testExecutionStateHolder;

    @Autowired
    public TestSpecificationExecutor(ExecutorService executorService, EventRepository eventRepository, ImportService importService, TestExecutionStateHolder testExecutionStateHolder) {
        this.executorService = executorService;
        this.eventRepository = eventRepository;
        this.importService = importService;
        this.testExecutionStateHolder = testExecutionStateHolder;
    }

    public String execute(Executable executable, Map<String, Object> parameters) throws Exception {
        return this.execute(executable, parameters, null, false);
    }

    public String forceExecute(Executable executable, Map<String, Object> parameters) throws Exception {
        return this.execute(executable, parameters, null, true);
    }

    public String importAllAvailableResults(final ActiveTestSpecification testSpecification) throws ImportException {
        String testRunId = UUID.randomUUID().toString();
        final String testSpecificationName = testSpecification.getName();
        this.testExecutionStateHolder.newTestRun(testSpecificationName, testRunId.toString());
        Future<String> task = this.executorService.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    TestSpecificationExecutor.this.testExecutionStateHolder.updateStartTime(testSpecificationName);
                    TestSpecificationExecutor.this.importService.importTestResults(testSpecification, UUID.randomUUID().toString(), testSpecification.getRemotePath());
                }
                catch (NothingToImportException e) {
                    LOG.info("Nothing to import for test specification {}: {}", (Object)testSpecificationName, (Object)e.getMessage());
                    throw e;
                }
                catch (UnexpectedFormatException | TestRunNotImportedInChronologicalOrderException e) {
                    LOG.error("Import failed: Error while importing test specification {}", (Object)testSpecificationName, (Object)e);
                    TestSpecificationExecutor.this.testExecutionStateHolder.updateQualification(testSpecificationName, false, e.getMessage());
                    throw e;
                }
                catch (ImportException e) {
                    LOG.info("Import failed for test specification {}: {}", (Object)testSpecificationName, (Object)e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    LOG.error("Exception: Error while importing test specification {}", (Object)testSpecificationName, (Object)e);
                    TestSpecificationExecutor.this.testExecutionStateHolder.updateQualification(testSpecificationName, false, e.getMessage());
                    throw new TestSpecificationExecutionException(testSpecificationName, "Error while importing test specification: " + e.getMessage(), e);
                }
                finally {
                    LOG.info("removing running task from local memory for specification {}", (Object)testSpecificationName);
                    TestSpecificationExecutor.this.testExecutionStateHolder.moveTaskToExpiredCache(testSpecificationName);
                }
                return testSpecificationName;
            }
        });
        LOG.info("putting taskContext for test specification {} in local memory", (Object)testSpecificationName);
        this.testExecutionStateHolder.updateTask(testSpecificationName, task);
        return testRunId;
    }

    private String execute(Executable baseTestSpec, Map<String, Object> parameters, CountDownLatch parentLatch, boolean force) throws Exception {
        String testRunId = UUID.randomUUID().toString();
        if (!force) {
            this.verifyNotExecutingAlready(baseTestSpec);
        }
        if (baseTestSpec instanceof TestSpecificationSet) {
            this.executeChildrenRecursively((TestSpecificationSet)baseTestSpec, parameters, testRunId, parentLatch, force);
        } else {
            this.executeSingleSpec((ExecutableTestSpecification)baseTestSpec, parameters, testRunId, parentLatch, this.getEventHandler(new String[0]));
        }
        return testRunId;
    }

    private void executeChildrenRecursively(TestSpecificationSet parentTestSpecification, Map<String, Object> parameters, String testRunId, CountDownLatch parentLatch, boolean force) throws Exception {
        CountDownLatch childCountDownLatch = new CountDownLatch(parentTestSpecification.getExecutableSpecifications().size());
        EventHandler parentEventHandler = this.getEventHandler(new String[0]);
        parentEventHandler.onReceive(this.parentStartEvent(testRunId, parentTestSpecification.getName()));
        this.testExecutionStateHolder.newTestRun(parentTestSpecification.getName(), testRunId);
        for (Executable childTestSpecification : parentTestSpecification.getExecutableSpecifications()) {
            if (childTestSpecification instanceof TestSpecificationSet) {
                this.execute(childTestSpecification, parameters, childCountDownLatch, force);
                continue;
            }
            String childRunId = UUID.randomUUID().toString();
            EventHandler eventHandler = this.getEventHandler(parentTestSpecification.getName());
            eventHandler.onReceive(this.childStartEvent(testRunId, childTestSpecification.getName(), childRunId));
            this.executeSingleSpec((ExecutableTestSpecification)childTestSpecification, parameters, childRunId, childCountDownLatch, eventHandler);
            eventHandler.onReceive(this.childFinishedEvent(childRunId, childTestSpecification.getName(), childRunId));
        }
        new WaitingParentThread(testRunId, parentTestSpecification.getName(), parentEventHandler, childCountDownLatch, parentLatch).start();
    }

    private void executeSingleSpec(ExecutableTestSpecification executable, Map<String, Object> parameters, String testRunId, CountDownLatch latch, EventHandler parentEventHandler) {
        String testSpecificationName = executable.getName();
        this.testExecutionStateHolder.newTestRun(testSpecificationName, testRunId);
        Future<String> task = this.submitSingleSpec(executable, parameters, testRunId, latch, parentEventHandler);
        LOG.info("putting taskContext for test specification {} in local memory", (Object)testSpecificationName);
        this.testExecutionStateHolder.updateTask(testSpecificationName, task);
    }

    private Future<String> submitSingleSpec(ExecutableTestSpecification testSpecification, Map<String, Object> parameters, String testRunId, CountDownLatch latch, EventHandler parentEventHandler) {
        return this.executorService.submit(new TestSpecificationCallable(testSpecification, testRunId, parameters, latch, parentEventHandler, this.testExecutionStateHolder, this.importService));
    }

    private EventHandler getEventHandler(final String ... testSpecifications) {
        return new EventHandler(){

            @Override
            public void onReceive(Event event) throws Exception {
                Event latestImportStartedEvent = TestSpecificationExecutor.this.eventRepository.fetchLatest(event.getTestSpecificationName(), "importStarted");
                TestSpecificationExecutor.checkNewEventIsModifiedAfterLatestExistingEvent(event, latestImportStartedEvent);
                TestSpecificationExecutor.this.eventRepository.insert(event);
                TestSpecificationExecutor.this.notifyExecutingRunCache(event, testSpecifications);
            }
        };
    }

    private void notifyExecutingRunCache(Event event, String[] testSpecifications) {
        if (event.getType().equals("executionStarted")) {
            this.testExecutionStateHolder.syncIfNeeded((String)event.get("@testSpecification"));
            this.testExecutionStateHolder.syncIfNeeded(testSpecifications);
        }
    }

    private void verifyNotExecutingAlready(Executable baseTestSpec) {
        if (baseTestSpec instanceof TestSpecificationSet) {
            try {
                for (Executable child : ((TestSpecificationSet)baseTestSpec).getExecutableSpecifications()) {
                    if (child instanceof TestSpecificationSet) {
                        this.verifyNotExecutingAlready(child);
                        continue;
                    }
                    this.checkSpecificationRunning(child.getName());
                }
            }
            catch (ExecutableAlreadyRunningException e) {
                throw new ExecutableAlreadyRunningException(baseTestSpec.getName(), "Can't execute " + baseTestSpec.getName() + " since one of its children " + e.getSpecificationName() + " is already running");
            }
        } else {
            this.checkSpecificationRunning(baseTestSpec.getName());
        }
    }

    private void checkSpecificationRunning(String specificationName) {
        if (this.testExecutionStateHolder.getFromRunningCache(specificationName) != null) {
            throw new ExecutableAlreadyRunningException(specificationName, "Can't execute test specification " + specificationName + " as it is already running");
        }
    }

    public void cancel(String testSpecificationName) {
        if (this.testExecutionStateHolder.getFromRunningCache(testSpecificationName) == null) {
            LOG.warn("Can't cancel the tasks since can't find any running tasks for specification {}", (Object)testSpecificationName);
            return;
        }
        Future<String> task = this.testExecutionStateHolder.getFromRunningCache(testSpecificationName).getTask();
        if (task != null && !task.isDone()) {
            boolean result = task.cancel(true);
            LOG.info("Requested to cancel test run for {} => {}", (Object)testSpecificationName, (Object)result);
        }
    }

    private Event childFinishedEvent(String testRunId, String specification, String childRunId) {
        return Event.create((String)"childFinished", (Object[])new Object[]{"@runId", testRunId, "childRunId", childRunId, "@testSpecification", specification});
    }

    private Event childStartEvent(String testRunId, String specification, String childRunId) {
        return Event.create((String)"childStarted", (Object[])new Object[]{"@runId", testRunId, "childRunId", childRunId, "@testSpecification", specification});
    }

    private Event parentFinishedEvent(String testRunId, String specification) {
        return Event.create((String)"executionFinished", (Object[])new Object[]{"@runId", testRunId, "@testSpecification", specification});
    }

    private Event parentStartEvent(String testRunId, String specification) {
        return Event.create((String)"executionStarted", (Object[])new Object[]{"@runId", testRunId, "@testSpecification", specification});
    }

    public static void checkNewEventIsModifiedAfterLatestExistingEvent(Event event, Event latestImportStartedEvent) throws TestRunNotImportedInChronologicalOrderException {
        if (latestImportStartedEvent != null && latestImportStartedEvent.getType().equals(event.getType()) && event.getTestedAt() < latestImportStartedEvent.getTestedAt()) {
            throw new TestRunNotImportedInChronologicalOrderException(event, latestImportStartedEvent);
        }
    }

    private class WaitingParentThread
    extends Thread {
        private final String testRunId;
        private final String specificationName;
        private final EventHandler parentEventHandler;
        private final CountDownLatch countDownLatch;
        private CountDownLatch parentCountDownLatch;

        public WaitingParentThread(String testRunId, String name, EventHandler parentEventHandler, CountDownLatch countDownLatch, CountDownLatch parentCountDownLatch) {
            this.testRunId = testRunId;
            this.specificationName = name;
            this.parentEventHandler = parentEventHandler;
            this.countDownLatch = countDownLatch;
            this.parentCountDownLatch = parentCountDownLatch;
        }

        @Override
        public void run() {
            try {
                this.countDownLatch.await();
                this.parentEventHandler.onReceive(TestSpecificationExecutor.this.parentFinishedEvent(this.testRunId, this.specificationName));
                TestSpecificationExecutor.this.testExecutionStateHolder.moveTaskToExpiredCache(this.specificationName);
                if (this.parentCountDownLatch != null) {
                    this.parentCountDownLatch.countDown();
                }
            }
            catch (Exception e) {
                LOG.error("Exception in WaitingParentThread (ignoring)", (Throwable)e);
            }
        }
    }
}

