/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;

public class JcrValueFactory
implements org.modeshape.jcr.api.ValueFactory {
    private static final JcrValue[] EMPTY_ARRAY = new JcrValue[0];
    private final ValueFactories valueFactories;
    private final NamespaceRegistry namespaces;
    private final String executionContextProcessId;

    protected JcrValueFactory(ExecutionContext context) {
        this.valueFactories = context.getValueFactories();
        this.namespaces = context.getNamespaceRegistry();
        this.executionContextProcessId = context.getProcessId();
    }

    public JcrValue[] createValues(List<?> values, int propertyType) throws javax.jcr.ValueFormatException {
        CheckArg.isNotNull(values, (String)"values");
        int size = values.size();
        if (size == 0) {
            return EMPTY_ARRAY;
        }
        JcrValue[] jcrValues = new JcrValue[size];
        int count = 0;
        ValueFactory<?> valueFactory = this.valueFactoryFor(propertyType);
        for (Object value : values) {
            try {
                Object objectValue = valueFactory.create(value);
                jcrValues[count++] = new JcrValue(this.valueFactories, propertyType, objectValue);
            }
            catch (ValueFormatException vfe) {
                throw new javax.jcr.ValueFormatException((Throwable)vfe);
            }
        }
        return jcrValues;
    }

    public JcrValue createValue(String value, int propertyType) throws javax.jcr.ValueFormatException {
        if (value == null) {
            return null;
        }
        return new JcrValue(this.valueFactories, propertyType, this.convertValueToType(value, propertyType));
    }

    public JcrValue createValue(Object value, int propertyType) throws javax.jcr.ValueFormatException {
        if (value == null) {
            return null;
        }
        return new JcrValue(this.valueFactories, propertyType, this.convertValueToType(value, propertyType));
    }

    public JcrValue createValue(Node value) throws RepositoryException {
        if (value == null) {
            return new JcrValue(this.valueFactories, 9, null);
        }
        AbstractJcrNode node = this.validateReferenceableNode(value);
        Reference ref = this.valueFactories.getReferenceFactory().create(node.key(), node.isForeign());
        return new JcrValue(this.valueFactories, 9, ref);
    }

    public JcrValue createValue(Node value, boolean weak) throws RepositoryException {
        if (value == null) {
            return new JcrValue(this.valueFactories, weak ? 10 : 9, null);
        }
        AbstractJcrNode node = this.validateReferenceableNode(value);
        ReferenceFactory factory = weak ? this.valueFactories.getWeakReferenceFactory() : this.valueFactories.getReferenceFactory();
        int refType = weak ? 10 : 9;
        Reference ref = factory.create(node.key(), node.isForeign());
        return new JcrValue(this.valueFactories, refType, ref);
    }

    private AbstractJcrNode validateReferenceableNode(Node value) throws RepositoryException {
        if (!value.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(this.namespaces))) {
            throw new RepositoryException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
        }
        if (!(value instanceof AbstractJcrNode)) {
            throw new IllegalArgumentException("Invalid node type (expected a ModeShape node): " + value.getClass().toString());
        }
        AbstractJcrNode node = (AbstractJcrNode)value;
        if (!node.isInTheSameProcessAs(this.executionContextProcessId)) {
            throw new RepositoryException(JcrI18n.nodeNotInTheSameSession.text(new Object[]{node.path()}));
        }
        return node;
    }

    public JcrValue createValue(Binary value) {
        if (value == null) {
            return null;
        }
        return new JcrValue(this.valueFactories, 2, value);
    }

    public JcrValue createValue(InputStream value) {
        if (value == null) {
            return null;
        }
        BinaryValue binary = (BinaryValue)this.valueFactories.getBinaryFactory().create(value);
        return new JcrValue(this.valueFactories, 2, binary);
    }

    public BinaryValue createBinary(InputStream value) {
        if (value == null) {
            return null;
        }
        return (BinaryValue)this.valueFactories.getBinaryFactory().create(value);
    }

    public BinaryValue createBinary(InputStream value, String hint) {
        if (value == null) {
            return null;
        }
        return (BinaryValue)this.valueFactories.getBinaryFactory().create(value, hint);
    }

    public JcrValue createValue(Calendar value) {
        if (value == null) {
            return null;
        }
        DateTime dateTime = (DateTime)this.valueFactories.getDateFactory().create(value);
        return new JcrValue(this.valueFactories, 5, dateTime);
    }

    public JcrValue createValue(boolean value) {
        return new JcrValue(this.valueFactories, 6, value);
    }

    public JcrValue createValue(double value) {
        return new JcrValue(this.valueFactories, 4, value);
    }

    public JcrValue createValue(long value) {
        return new JcrValue(this.valueFactories, 3, value);
    }

    public JcrValue createValue(String value) {
        if (value == null) {
            return null;
        }
        return new JcrValue(this.valueFactories, 1, value);
    }

    public JcrValue createValue(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return new JcrValue(this.valueFactories, 12, value);
    }

    public BinaryValue createBinary(byte[] value) {
        if (value == null) {
            return null;
        }
        return (BinaryValue)this.valueFactories.getBinaryFactory().create(value);
    }

    public JcrValue createValue(Date value) {
        if (value == null) {
            return null;
        }
        return new JcrValue(this.valueFactories, 5, value);
    }

    public Value createValue(URI value) {
        if (value == null) {
            return null;
        }
        return new JcrValue(this.valueFactories, 11, value);
    }

    public JcrValue createValue(Reference value) {
        if (value == null) {
            return null;
        }
        int refType = value.isWeak() ? 10 : 9;
        return new JcrValue(this.valueFactories, refType, value);
    }

    public String createName(String localName) {
        return this.valueFactories.getNameFactory().create((String)null, localName).getString();
    }

    public String createName(String namespaceUri, String localName) {
        return this.valueFactories.getNameFactory().create(namespaceUri, localName).getString();
    }

    public JcrValue createSimpleReference(Node node) throws RepositoryException {
        AbstractJcrNode abstractJcrNode = this.validateReferenceableNode(node);
        Reference ref = this.valueFactories.getSimpleReferenceFactory().create(abstractJcrNode.key(), abstractJcrNode.isForeign());
        return new JcrValue(this.valueFactories, 100, ref);
    }

    protected ValueFactory<?> valueFactoryFor(int jcrPropertyType) {
        switch (jcrPropertyType) {
            case 6: {
                return this.valueFactories.getBooleanFactory();
            }
            case 5: {
                return this.valueFactories.getDateFactory();
            }
            case 7: {
                return this.valueFactories.getNameFactory();
            }
            case 8: {
                return this.valueFactories.getPathFactory();
            }
            case 9: {
                return this.valueFactories.getReferenceFactory();
            }
            case 10: {
                return this.valueFactories.getWeakReferenceFactory();
            }
            case 100: {
                return this.valueFactories.getSimpleReferenceFactory();
            }
            case 4: {
                return this.valueFactories.getDoubleFactory();
            }
            case 3: {
                return this.valueFactories.getLongFactory();
            }
            case 12: {
                return this.valueFactories.getDecimalFactory();
            }
            case 11: {
                return this.valueFactories.getUriFactory();
            }
            case 2: {
                return this.valueFactories.getBinaryFactory();
            }
            case 1: {
                return this.valueFactories.getStringFactory();
            }
            case 0: {
                return this.valueFactories.getObjectFactory();
            }
        }
        assert (false) : "Unexpected JCR property type " + jcrPropertyType;
        throw new IllegalStateException("Invalid property type " + jcrPropertyType);
    }

    protected Object convertValueToType(Object value, int toType) throws javax.jcr.ValueFormatException {
        try {
            return this.valueFactoryFor(toType).create(value);
        }
        catch (ValueFormatException vfe) {
            throw new javax.jcr.ValueFormatException((Throwable)vfe);
        }
    }
}

