/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.CndImporter;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.value.NamespaceRegistry;

public final class NodeTypesImporter {
    protected final JcrRepository.RunningState repository;
    private final List<String> nodeTypesFiles;

    protected NodeTypesImporter(List<String> nodeTypesFiles, JcrRepository.RunningState repository) {
        this.nodeTypesFiles = nodeTypesFiles;
        this.repository = repository;
    }

    void importNodeTypes() throws RepositoryException {
        if (this.nodeTypesFiles.isEmpty()) {
            return;
        }
        ArrayList<NodeTypeDefinition> nodeTypeDefinitions = new ArrayList<NodeTypeDefinition>();
        HashSet<NamespaceRegistry.Namespace> namespaces = new HashSet<NamespaceRegistry.Namespace>();
        for (String cndFile : this.nodeTypesFiles) {
            CndImportOperation cndImportOperation = new CndImportOperation();
            cndImportOperation.execute(cndFile);
            nodeTypeDefinitions.addAll(cndImportOperation.getNodeTypeDefinitions());
            namespaces.addAll(cndImportOperation.getNamespaces());
        }
        if (!nodeTypeDefinitions.isEmpty()) {
            this.repository.nodeTypeManager().registerNodeTypes(nodeTypeDefinitions, false, false, true);
        }
        if (!namespaces.isEmpty()) {
            this.repository.persistentRegistry().register(namespaces);
        }
    }

    private final class CndImportOperation {
        private List<NodeTypeDefinition> nodeTypeDefinitions = Collections.emptyList();
        private Set<NamespaceRegistry.Namespace> namespaces = Collections.emptySet();

        protected CndImportOperation() {
        }

        void execute(String cndFile) {
            try {
                InputStream cndFileStream = this.getInputStreamForFile(cndFile);
                if (cndFileStream == null) {
                    NodeTypesImporter.this.repository.warn(JcrI18n.cannotLoadCndFile, cndFile);
                    return;
                }
                CndImporter cndImporter = new CndImporter(NodeTypesImporter.this.repository.context());
                SimpleProblems importProblems = new SimpleProblems();
                cndImporter.importFrom(cndFileStream, (Problems)importProblems, cndFile);
                for (Problem problem : importProblems) {
                    if (problem.getStatus() == Problem.Status.ERROR) {
                        if (problem.getThrowable() != null) {
                            NodeTypesImporter.this.repository.error(problem.getThrowable(), problem.getMessage(), problem.getParameters());
                            continue;
                        }
                        NodeTypesImporter.this.repository.error(problem.getMessage(), problem.getParameters());
                        continue;
                    }
                    if (problem.getStatus() != Problem.Status.WARNING) continue;
                    NodeTypesImporter.this.repository.warn(problem.getMessage(), problem.getParameters());
                }
                if (importProblems.hasErrors()) {
                    return;
                }
                this.nodeTypeDefinitions = cndImporter.getNodeTypeDefinitions();
                this.namespaces = cndImporter.getNamespaces();
            }
            catch (IOException e) {
                NodeTypesImporter.this.repository.error(e, JcrI18n.errorReadingCndFile, cndFile);
            }
        }

        private InputStream getInputStreamForFile(String cndFileString) {
            return IoUtil.getResourceAsStream((String)cndFileString, (ClassLoader)NodeTypesImporter.this.repository.environment().getClassLoader(NodeTypesImporter.class.getClassLoader(), new String[0]), null);
        }

        Set<NamespaceRegistry.Namespace> getNamespaces() {
            return this.namespaces;
        }

        List<NodeTypeDefinition> getNodeTypeDefinitions() {
            return this.nodeTypeDefinitions;
        }
    }
}

