/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.NodeTypeExistsException;
import org.modeshape.jcr.NodeTypeSchemata;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryIndexes;
import org.modeshape.jcr.RepositoryQueryManager;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.query.CancellableQuery;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.parse.BasicSqlQueryParser;
import org.modeshape.jcr.query.parse.QueryParser;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFactory;

@ThreadSafe
class RepositoryNodeTypeManager
implements ChangeSetListener,
NodeTypes.Supplier {
    private final JcrRepository.RunningState repository;
    private final ExecutionContext context;
    private final String systemWorkspaceName;
    private final Path nodeTypesPath;
    private final NameFactory nameFactory;
    private final Logger logger = Logger.getLogger(this.getClass());
    private final ReadWriteLock nodeTypesLock = new ReentrantReadWriteLock();
    private volatile NodeTypes nodeTypesCache;
    private final QueryParser queryParser;
    private final boolean includeColumnsForInheritedProperties;
    private final boolean includePseudoColumnsInSelectStar;
    private volatile NodeTypeSchemata schemata;
    private final CopyOnWriteArrayList<NodeTypes.Listener> listeners = new CopyOnWriteArrayList();

    RepositoryNodeTypeManager(JcrRepository.RunningState repository, boolean includeColumnsForInheritedProperties, boolean includePseudoColumnsInSelectStar) {
        this.repository = repository;
        this.context = repository.context();
        this.nameFactory = this.context.getValueFactories().getNameFactory();
        this.systemWorkspaceName = this.repository.repositoryCache().getSystemWorkspaceName();
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        this.nodeTypesPath = pathFactory.createAbsolutePath(JcrLexicon.SYSTEM, JcrLexicon.NODE_TYPES);
        this.nodeTypesCache = new NodeTypes(this.context);
        this.includeColumnsForInheritedProperties = includeColumnsForInheritedProperties;
        this.includePseudoColumnsInSelectStar = includePseudoColumnsInSelectStar;
        this.queryParser = new BasicSqlQueryParser();
    }

    RepositoryNodeTypeManager with(JcrRepository.RunningState repository, boolean includeColumnsForInheritedProperties, boolean includePseudoColumnsInSelectStar) {
        assert (this.systemWorkspaceName.equals(repository.repositoryCache().getSystemWorkspaceName()));
        PathFactory pathFactory = repository.context().getValueFactories().getPathFactory();
        Path nodeTypesPath = pathFactory.createAbsolutePath(JcrLexicon.SYSTEM, JcrLexicon.NODE_TYPES);
        assert (this.nodeTypesPath.equals(nodeTypesPath));
        RepositoryNodeTypeManager result = new RepositoryNodeTypeManager(repository, includeColumnsForInheritedProperties, includePseudoColumnsInSelectStar);
        result.nodeTypesCache = result.nodeTypesCache.with(this.nodeTypesCache.getAllNodeTypes());
        return result;
    }

    protected final ValueFactory<String> strings() {
        return this.context.getValueFactories().getStringFactory();
    }

    @Override
    public NodeTypes getNodeTypes() {
        return this.nodeTypesCache;
    }

    final boolean registerListener(NodeTypes.Listener listener) {
        return listener != null ? this.listeners.addIfAbsent(listener) : false;
    }

    final boolean unregisterListener(NodeTypes.Listener listener) {
        return this.listeners.remove(listener);
    }

    private void notifiyListeners() {
        for (NodeTypes.Listener listener : this.listeners) {
            assert (listener != null);
            try {
                listener.notify(this.nodeTypesCache);
            }
            catch (RuntimeException e) {
                this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorNotifyingNodeTypesListener, new Object[]{listener});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterNodeType(Collection<Name> nodeTypeNames, boolean failIfNodeTypesAreUsed) throws NoSuchNodeTypeException, InvalidNodeTypeDefinitionException, RepositoryException {
        CheckArg.isNotNull(nodeTypeNames, (String)"nodeTypeNames");
        if (nodeTypeNames.isEmpty()) {
            return;
        }
        if (failIfNodeTypesAreUsed) {
            long start = System.nanoTime();
            for (Name nodeTypeName : nodeTypeNames) {
                if (!this.isNodeTypeInUse(nodeTypeName)) continue;
                String name = nodeTypeName.getString(this.context.getNamespaceRegistry());
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterInUseType.text(new Object[]{name}));
            }
            long time = TimeUnit.MILLISECONDS.convert(Math.abs(System.nanoTime() - start), TimeUnit.NANOSECONDS);
            this.logger.debug("{0} milliseconds to check if any of these node types are unused before unregistering them: {1}", new Object[]{time, nodeTypeNames});
        }
        try {
            ArrayList<JcrNodeType> removedNodeTypes = new ArrayList<JcrNodeType>(nodeTypeNames.size());
            this.nodeTypesLock.writeLock().lock();
            NodeTypes nodeTypes = this.nodeTypesCache;
            for (Name nodeTypeName : nodeTypeNames) {
                if (nodeTypeName == null) {
                    throw new NoSuchNodeTypeException(JcrI18n.invalidNodeTypeName.text(new Object[0]));
                }
                String name = nodeTypeName.getString(this.context.getNamespaceRegistry());
                JcrNodeType foundNodeType = nodeTypes.getNodeType(nodeTypeName);
                if (foundNodeType == null) {
                    throw new NoSuchNodeTypeException(JcrI18n.noSuchNodeType.text(new Object[]{name}));
                }
                removedNodeTypes.add(foundNodeType);
                for (JcrNodeType nodeType : nodeTypes.getAllNodeTypes()) {
                    if (nodeTypeNames.contains(nodeType.getInternalName())) continue;
                    for (JcrNodeType supertype : nodeType.supertypes()) {
                        if (!nodeTypeName.equals(supertype.getInternalName())) continue;
                        throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterSupertype.text(new Object[]{name, nodeType.getName()}));
                    }
                    for (JcrNodeDefinition childNode : nodeType.childNodeDefinitions()) {
                        JcrNodeType defaultPrimaryType = childNode.getDefaultPrimaryType();
                        if (defaultPrimaryType != null && name.equals(defaultPrimaryType.getName())) {
                            throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterDefaultPrimaryType.text(new Object[]{name, nodeType.getName(), childNode.getName()}));
                        }
                        if (!childNode.requiredPrimaryTypeNameSet().contains(nodeTypeName)) continue;
                        throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterRequiredPrimaryType.text(new Object[]{name, nodeType.getName(), childNode.getName()}));
                    }
                }
            }
            NodeTypes newNodeTypes = nodeTypes.without(removedNodeTypes);
            SessionCache system = this.repository.createSystemSession(this.context, false);
            SystemContent systemContent = new SystemContent(system);
            systemContent.unregisterNodeTypes(removedNodeTypes.toArray(new JcrNodeType[removedNodeTypes.size()]));
            systemContent.save();
            this.nodeTypesCache = newNodeTypes;
            this.schemata = null;
            this.notifiyListeners();
        }
        finally {
            this.nodeTypesLock.writeLock().unlock();
        }
    }

    NodeTypeSchemata getRepositorySchemata() {
        if (this.schemata != null) {
            return this.schemata;
        }
        this.schemata = new NodeTypeSchemata(this.context, this.nodeTypesCache, this.includeColumnsForInheritedProperties, this.includePseudoColumnsInSelectStar);
        return this.schemata;
    }

    void signalNamespaceChanges() {
        this.schemata = null;
    }

    boolean isNodeTypeInUse(Name nodeTypeName) throws InvalidQueryException {
        String nodeTypeString = nodeTypeName.getString(this.context.getNamespaceRegistry());
        String expression = "SELECT * from [" + nodeTypeString + "] LIMIT 1";
        TypeSystem typeSystem = this.context.getValueFactories().getTypeSystem();
        QueryCommand command = this.queryParser.parseQuery(expression, typeSystem);
        assert (command != null) : "Could not parse " + expression;
        NodeTypeSchemata schemata = this.getRepositorySchemata();
        RepositoryCache repoCache = this.repository.repositoryCache();
        RepositoryQueryManager queryManager = this.repository.queryManager();
        Set<String> workspaceNames = repoCache.getWorkspaceNames();
        Map<String, NodeCache> overridden = null;
        NodeTypes nodeTypes = this.repository.nodeTypeManager().getNodeTypes();
        RepositoryIndexes indexDefns = this.repository.queryManager().getIndexes();
        CancellableQuery query = queryManager.query(this.context, repoCache, workspaceNames, overridden, command, schemata, indexDefns, nodeTypes, null, null);
        try {
            QueryResults result = query.execute();
            if (result.isEmpty()) {
                return false;
            }
            if (result.getRowCount() < 0L) {
                NodeSequence seq = result.getRows();
                NodeSequence.Batch batch = seq.nextBatch();
                while (batch != null) {
                    if (batch.hasNext()) {
                        return true;
                    }
                    batch = seq.nextBatch();
                }
                return false;
            }
            return result.getRowCount() > 0L;
        }
        catch (RepositoryException e) {
            this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorCheckingNodeTypeUsage, new Object[]{nodeTypeName, e.getLocalizedMessage()});
            return true;
        }
    }

    JcrNodeType registerNodeType(NodeTypeDefinition ntd) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        return this.registerNodeType(ntd, true);
    }

    JcrNodeType registerNodeType(NodeTypeDefinition ntd, boolean failIfNodeTypeExists) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        assert (ntd != null);
        List<JcrNodeType> result = this.registerNodeTypes(Collections.singletonList(ntd), failIfNodeTypeExists, false, true);
        return result.isEmpty() ? null : result.get(0);
    }

    List<JcrNodeType> registerNodeTypes(Iterable<NodeTypeDefinition> nodeTypeDefns) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        return this.registerNodeTypes(nodeTypeDefns, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<JcrNodeType> registerNodeTypes(Iterable<NodeTypeDefinition> nodeTypeDefns, boolean failIfNodeTypeDefinitionsExist, boolean skipIfNodeTypeDefinitionExists, boolean persist) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        if (nodeTypeDefns == null) {
            return Collections.emptyList();
        }
        ArrayList<JcrNodeType> typesPendingRegistration = new ArrayList<JcrNodeType>();
        try {
            this.nodeTypesLock.writeLock().lock();
            NodeTypes nodeTypes = this.nodeTypesCache;
            for (Object nodeTypeDefn : nodeTypeDefns) {
                Name internalName;
                if (nodeTypeDefn instanceof JcrNodeTypeTemplate) {
                    nodeTypeDefn = ((JcrNodeTypeTemplate)nodeTypeDefn).with(this.context);
                }
                if ((internalName = (Name)nodeTypes.nameFactory().create(nodeTypeDefn.getName())) == null || internalName.getLocalName().length() == 0) {
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.invalidNodeTypeName.text(new Object[0]));
                }
                boolean found = nodeTypes.hasNodeType(internalName);
                if (found && failIfNodeTypeDefinitionsExist) {
                    String name = nodeTypeDefn.getName();
                    throw new NodeTypeExistsException(internalName, JcrI18n.nodeTypeAlreadyExists.text(new Object[]{name}));
                }
                if (found && skipIfNodeTypeDefinitionExists) continue;
                List<JcrNodeType> supertypes = nodeTypes.supertypesFor((NodeTypeDefinition)nodeTypeDefn, (Collection<JcrNodeType>)typesPendingRegistration);
                JcrNodeType nodeType = this.nodeTypeFrom((NodeTypeDefinition)nodeTypeDefn, supertypes);
                typesPendingRegistration.add(nodeType);
            }
            if (!typesPendingRegistration.isEmpty()) {
                this.validateTypes(typesPendingRegistration);
                for (JcrNodeType typePendingRegistration : typesPendingRegistration) {
                    nodeTypes.validate(typePendingRegistration, Arrays.asList(typePendingRegistration.getDeclaredSupertypes()), typesPendingRegistration);
                }
                SystemContent system = null;
                if (persist) {
                    SessionCache systemCache = this.repository.createSystemSession(this.context, false);
                    system = new SystemContent(systemCache);
                }
                for (JcrNodeType nodeType : typesPendingRegistration) {
                    if (system == null) continue;
                    system.store(nodeType, true);
                }
                NodeTypes newNodeTypes = nodeTypes.with(typesPendingRegistration);
                if (system != null) {
                    system.save();
                }
                this.nodeTypesCache = newNodeTypes;
                this.schemata = null;
                this.notifiyListeners();
            }
        }
        finally {
            this.nodeTypesLock.writeLock().unlock();
        }
        return typesPendingRegistration;
    }

    private void validateTypes(List<JcrNodeType> typesPendingRegistration) throws RepositoryException {
        NodeTypes nodeTypes = this.nodeTypesCache;
        for (JcrNodeType nodeType : typesPendingRegistration) {
            for (JcrNodeDefinition jcrNodeDefinition : nodeType.getDeclaredChildNodeDefinitions()) {
                Name[] requiredPrimaryTypeNames;
                for (Name primaryTypeName : requiredPrimaryTypeNames = jcrNodeDefinition.requiredPrimaryTypeNames()) {
                    JcrNodeType requiredPrimaryType = nodeTypes.findTypeInMapOrList(primaryTypeName, typesPendingRegistration);
                    if (requiredPrimaryType != null) continue;
                    String msg = JcrI18n.invalidPrimaryTypeName.text(new Object[]{primaryTypeName, nodeType.getName()});
                    throw new RepositoryException(msg);
                }
            }
            if (!nodeType.isMixin()) continue;
            for (JcrNodeDefinition jcrNodeDefinition : nodeType.getSupertypes()) {
                if (jcrNodeDefinition.isMixin()) continue;
                String msg = JcrI18n.invalidMixinSupertype.text(new Object[]{nodeType.getName(), jcrNodeDefinition.getName()});
                throw new RepositoryException(msg);
            }
        }
    }

    private JcrNodeType nodeTypeFrom(NodeTypeDefinition nodeType, List<JcrNodeType> supertypes) throws RepositoryException {
        PropertyDefinition[] propDefns = nodeType.getDeclaredPropertyDefinitions();
        NodeDefinition[] childDefns = nodeType.getDeclaredChildNodeDefinitions();
        ArrayList<JcrPropertyDefinition> properties = new ArrayList<JcrPropertyDefinition>();
        ArrayList<JcrNodeDefinition> childNodes = new ArrayList<JcrNodeDefinition>();
        if (propDefns != null) {
            for (PropertyDefinition propertyDefinition : propDefns) {
                properties.add(this.propertyDefinitionFrom(propertyDefinition));
            }
        }
        if (childDefns != null) {
            for (PropertyDefinition propertyDefinition : childDefns) {
                childNodes.add(this.childNodeDefinitionFrom((NodeDefinition)propertyDefinition));
            }
        }
        Name name = (Name)this.nameFactory.create(nodeType.getName());
        Name primaryItemName = (Name)this.nameFactory.create(nodeType.getPrimaryItemName());
        boolean mixin = nodeType.isMixin();
        boolean bl = nodeType.isAbstract();
        boolean queryable = nodeType.isQueryable();
        boolean orderableChildNodes = nodeType.hasOrderableChildNodes();
        NodeKey prototypeKey = this.repository.repositoryCache().getSystemKey();
        return new JcrNodeType(prototypeKey, this.context, null, this, name, supertypes, primaryItemName, childNodes, properties, mixin, bl, queryable, orderableChildNodes);
    }

    private JcrPropertyDefinition propertyDefinitionFrom(PropertyDefinition propDefn) throws RepositoryException {
        Name propertyName = (Name)this.nameFactory.create(propDefn.getName());
        int onParentVersionBehavior = propDefn.getOnParentVersion();
        int requiredType = propDefn.getRequiredType();
        boolean mandatory = propDefn.isMandatory();
        boolean multiple = propDefn.isMultiple();
        boolean autoCreated = propDefn.isAutoCreated();
        boolean isProtected = propDefn.isProtected();
        boolean fullTextSearchable = propDefn.isFullTextSearchable();
        boolean queryOrderable = propDefn.isQueryOrderable();
        Value[] defaultValues = propDefn.getDefaultValues();
        JcrValue[] jcrDefaultValues = null;
        if (defaultValues != null) {
            jcrDefaultValues = new JcrValue[defaultValues.length];
            for (int i = 0; i != defaultValues.length; ++i) {
                Value value = defaultValues[i];
                jcrDefaultValues[i] = new JcrValue(this.context.getValueFactories(), value);
            }
        }
        String[] valueConstraints = propDefn.getValueConstraints();
        String[] queryOperators = propDefn.getAvailableQueryOperators();
        if (valueConstraints == null) {
            valueConstraints = new String[]{};
        }
        NodeKey prototypeKey = this.repository.repositoryCache().getSystemKey();
        return new JcrPropertyDefinition(this.context, null, prototypeKey, propertyName, onParentVersionBehavior, autoCreated, mandatory, isProtected, jcrDefaultValues, requiredType, valueConstraints, multiple, fullTextSearchable, queryOrderable, queryOperators);
    }

    private JcrNodeDefinition childNodeDefinitionFrom(NodeDefinition childNodeDefn) {
        Name[] requiredTypes;
        Name childNodeName = (Name)this.nameFactory.create(childNodeDefn.getName());
        Name defaultPrimaryTypeName = (Name)this.nameFactory.create(childNodeDefn.getDefaultPrimaryTypeName());
        int onParentVersion = childNodeDefn.getOnParentVersion();
        boolean mandatory = childNodeDefn.isMandatory();
        boolean allowsSns = childNodeDefn.allowsSameNameSiblings();
        boolean autoCreated = childNodeDefn.isAutoCreated();
        boolean isProtected = childNodeDefn.isProtected();
        String[] requiredTypeNames = childNodeDefn.getRequiredPrimaryTypeNames();
        if (requiredTypeNames != null) {
            ArrayList names = new ArrayList(requiredTypeNames.length);
            for (String typeName : requiredTypeNames) {
                names.add(this.nameFactory.create(typeName));
            }
            requiredTypes = names.toArray(new Name[names.size()]);
        } else {
            requiredTypes = new Name[]{};
        }
        NodeKey prototypeKey = this.repository.repositoryCache().getSystemKey();
        return new JcrNodeDefinition(this.context, null, prototypeKey, childNodeName, onParentVersion, autoCreated, mandatory, isProtected, allowsSns, defaultPrimaryTypeName, requiredTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(ChangeSet changeSet) {
        if (!this.systemWorkspaceName.equals(changeSet.getWorkspaceName())) {
            return;
        }
        if (this.context.getProcessId().equals(changeSet.getProcessKey())) {
            return;
        }
        HashSet<Name> nodeTypesToRefresh = new HashSet<Name>();
        HashSet<Name> nodeTypesToDelete = new HashSet<Name>();
        for (Change change : changeSet) {
            PropertyChanged propChanged;
            Path changedPath;
            Name nodeTypeName;
            if (change instanceof NodeAdded) {
                NodeAdded added = (NodeAdded)change;
                Path addedPath = added.getPath();
                if (!this.nodeTypesPath.isAncestorOf(addedPath)) continue;
                nodeTypeName = addedPath.getSegment(2).getName();
                nodeTypesToRefresh.add(nodeTypeName);
                continue;
            }
            if (change instanceof NodeRemoved) {
                NodeRemoved removed = (NodeRemoved)change;
                Path removedPath = removed.getPath();
                if (!this.nodeTypesPath.isAncestorOf(removedPath)) continue;
                nodeTypeName = removedPath.getSegment(2).getName();
                if (removedPath.size() == 3) {
                    nodeTypesToDelete.add(nodeTypeName);
                    continue;
                }
                if (nodeTypesToDelete.contains(nodeTypeName)) continue;
                nodeTypesToRefresh.add(nodeTypeName);
                continue;
            }
            if (!(change instanceof PropertyChanged) || !this.nodeTypesPath.isAncestorOf(changedPath = (propChanged = (PropertyChanged)change).getPathToNode())) continue;
            nodeTypeName = changedPath.getSegment(2).getName();
            nodeTypesToRefresh.add(nodeTypeName);
        }
        if (nodeTypesToRefresh.isEmpty() && nodeTypesToDelete.isEmpty()) {
            return;
        }
        this.nodeTypesLock.writeLock().lock();
        try {
            SessionCache systemCache = this.repository.createSystemSession(this.context, false);
            SystemContent system = new SystemContent(systemCache);
            List<NodeTypeDefinition> nodeTypes = system.readNodeTypes(nodeTypesToRefresh);
            this.registerNodeTypes(nodeTypes, false, false, false);
            this.unregisterNodeType(nodeTypesToDelete, false);
        }
        catch (Throwable e) {
            this.logger.error(e, (I18nResource)JcrI18n.errorRefreshingNodeTypes, new Object[]{this.repository.name()});
        }
        finally {
            this.nodeTypesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshFromSystem() {
        this.nodeTypesLock.writeLock().lock();
        try {
            SessionCache systemCache = this.repository.createSystemSession(this.context, true);
            SystemContent system = new SystemContent(systemCache);
            List<NodeTypeDefinition> nodeTypes = system.readAllNodeTypes();
            if (nodeTypes.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.registerNodeTypes(nodeTypes, false, false, false);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.logger.error(e, (I18nResource)JcrI18n.errorRefreshingNodeTypes, new Object[]{this.repository.name()});
            boolean bl = false;
            return bl;
        }
        finally {
            this.nodeTypesLock.writeLock().unlock();
        }
    }

    public String toString() {
        return this.getNodeTypes().toString();
    }
}

