/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.bus;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.modeshape.common.collection.ring.RingBuffer;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.bus.BusI18n;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.bus.RepositoryRingBufferBuilder;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;

public final class RepositoryChangeBus
implements ChangeBus {
    public static final int DEFAULT_RING_BUFFER_SIZE = 1024;
    protected static final Logger LOGGER = Logger.getLogger(RepositoryChangeBus.class);
    private final AtomicBoolean shutdown = new AtomicBoolean(true);
    private final Lock registrationLock = new ReentrantLock();
    private final Set<ChangeSetListener> inThreadListeners = new CopyOnWriteArraySet<ChangeSetListener>();
    private final RingBuffer<ChangeSet, ChangeSetListener> ringBuffer;
    private final RepositoryStatistics statistics;

    public RepositoryChangeBus(String repositoryName, ExecutorService executor) {
        this(repositoryName, executor, null, 1024);
    }

    public RepositoryChangeBus(String repositoryName, ExecutorService executor, RepositoryStatistics statistics, int bufferSize) {
        this.ringBuffer = RepositoryRingBufferBuilder.withMultipleProducers(executor, new ChangeSetListenerConsumerAdapter(), statistics).ofSize(bufferSize).named(repositoryName).garbageCollect(true).build();
        this.statistics = statistics;
    }

    @Override
    public boolean hasObservers() {
        if (this.shutdown.get()) {
            return false;
        }
        return !this.inThreadListeners.isEmpty() || this.ringBuffer.hasConsumers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(ChangeSetListener observer) {
        if (observer == null || this.shutdown.get()) {
            return false;
        }
        try {
            this.registrationLock.lock();
            boolean result = this.ringBuffer.addConsumer((Object)observer);
            if (result && this.statistics != null) {
                this.statistics.increment(ValueMetric.LISTENER_COUNT);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerInThread(ChangeSetListener observer) {
        if (observer == null || this.shutdown.get()) {
            return false;
        }
        try {
            this.registrationLock.lock();
            boolean result = this.inThreadListeners.add(observer);
            if (result && this.statistics != null) {
                this.statistics.increment(ValueMetric.LISTENER_COUNT);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(ChangeSetListener observer) {
        if (observer == null || this.shutdown.get()) {
            return false;
        }
        try {
            boolean result;
            this.registrationLock.lock();
            boolean bl = result = this.ringBuffer.remove((Object)observer) || this.inThreadListeners.remove(observer);
            if (result && this.statistics != null) {
                this.statistics.decrement(ValueMetric.LISTENER_COUNT);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    @Override
    public synchronized void start() throws Exception {
        this.shutdown.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        try {
            this.registrationLock.lock();
            this.inThreadListeners.clear();
            this.ringBuffer.shutdown();
            if (this.statistics != null) {
                this.statistics.set(ValueMetric.LISTENER_COUNT, 0L);
            }
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    @Override
    public void notify(ChangeSet changeSet) {
        if (changeSet == null || !this.hasObservers()) {
            return;
        }
        if (this.shutdown.get()) {
            throw new IllegalStateException("Change bus has been already shut down, should not have any more observers");
        }
        this.ringBuffer.add((Object)changeSet);
        if (this.statistics != null) {
            this.statistics.increment(ValueMetric.EVENT_COUNT);
        }
        for (ChangeSetListener listener : this.inThreadListeners) {
            try {
                listener.notify(changeSet);
            }
            catch (RuntimeException e) {
                if (this.shutdown.get()) continue;
                throw e;
            }
        }
    }

    protected class ChangeSetListenerConsumerAdapter
    implements RingBuffer.ConsumerAdapter<ChangeSet, ChangeSetListener> {
        protected ChangeSetListenerConsumerAdapter() {
        }

        public boolean consume(ChangeSetListener consumer, ChangeSet event, long position, long maxPosition) {
            consumer.notify(event);
            return true;
        }

        public void close(ChangeSetListener consumer) {
        }

        public void handleException(ChangeSetListener consumer, Throwable t, ChangeSet entry, long position, long maxPosition) {
            LOGGER.error(t, (I18nResource)BusI18n.errorProcessingEvent, new Object[]{entry.toString(), position});
        }
    }
}

