/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.federation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Document;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.spi.federation.DocumentReader;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;

public class FederatedDocumentReader
implements DocumentReader {
    private final Document federatedDocument;
    private final DocumentTranslator translator;

    public FederatedDocumentReader(DocumentTranslator translator, Document federatedDocument) {
        this.federatedDocument = federatedDocument;
        this.translator = translator;
    }

    @Override
    public String getDocumentId() {
        return this.translator.getKey(this.federatedDocument);
    }

    @Override
    public List<String> getParentIds() {
        ArrayList<String> parents = new ArrayList<String>();
        if (!this.federatedDocument.containsField("parent")) {
            return parents;
        }
        Object parentFieldValue = this.federatedDocument.get("parent");
        if (parentFieldValue instanceof Array) {
            for (Array.Entry entry : ((Array)parentFieldValue).getEntries()) {
                parents.add(entry.getValue().toString());
            }
        } else {
            parents.add(parentFieldValue.toString());
        }
        return parents;
    }

    public List<Document> getChildren() {
        ArrayList<Document> children = new ArrayList<Document>();
        if (!this.federatedDocument.containsField("children")) {
            return children;
        }
        List childrenArray = this.federatedDocument.getArray("children");
        for (Object child : childrenArray) {
            assert (child instanceof Document);
            children.add((Document)child);
        }
        return children;
    }

    @Override
    public LinkedHashMap<String, Name> getChildrenMap() {
        LinkedHashMap<String, Name> children = new LinkedHashMap<String, Name>();
        if (!this.federatedDocument.containsField("children")) {
            return children;
        }
        List childrenArray = this.federatedDocument.getArray("children");
        for (Object child : childrenArray) {
            assert (child instanceof Document);
            Document childDocument = (Document)child;
            String childId = this.translator.getKey(childDocument);
            Name childName = (Name)this.translator.getNameFactory().create(childDocument.get("name"));
            children.put(childId, childName);
        }
        return children;
    }

    @Override
    public Name getPrimaryType() {
        return this.translator.getPrimaryType(this.federatedDocument);
    }

    @Override
    public Set<Name> getMixinTypes() {
        return this.translator.getMixinTypes(this.federatedDocument);
    }

    @Override
    public String getPrimaryTypeName() {
        return this.translator.getPrimaryTypeName(this.federatedDocument);
    }

    @Override
    public Set<String> getMixinTypeNames() {
        return this.translator.getMixinTypeNames(this.federatedDocument);
    }

    @Override
    public Map<Name, Property> getProperties() {
        HashMap<Name, Property> props = new HashMap<Name, Property>();
        this.translator.getProperties(this.federatedDocument, props);
        return props;
    }

    @Override
    public Property getProperty(Name name) {
        return this.translator.getProperty(this.federatedDocument, name);
    }

    @Override
    public Property getProperty(String name) {
        return this.translator.getProperty(this.federatedDocument, name);
    }

    @Override
    public Document document() {
        return this.federatedDocument;
    }

    @Override
    public Integer getCacheTtlSeconds() {
        return this.federatedDocument.getInteger("cacheTtlSeconds");
    }

    @Override
    public boolean isQueryable() {
        return this.federatedDocument.getBoolean("$queryable", true);
    }
}

