/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.RepositoryException;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;
import org.modeshape.common.xml.XmlCharacters;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.ArithmeticOperand;
import org.modeshape.jcr.query.model.ArithmeticOperator;
import org.modeshape.jcr.query.model.Between;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.ChildCount;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.ChildNodeJoinCondition;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DescendantNodeJoinCondition;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.EquiJoinCondition;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.FullTextSearchScore;
import org.modeshape.jcr.query.model.Join;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.Limit;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.LowerCase;
import org.modeshape.jcr.query.model.NamedSelector;
import org.modeshape.jcr.query.model.NodeDepth;
import org.modeshape.jcr.query.model.NodeId;
import org.modeshape.jcr.query.model.NodeLocalName;
import org.modeshape.jcr.query.model.NodeName;
import org.modeshape.jcr.query.model.NodePath;
import org.modeshape.jcr.query.model.Not;
import org.modeshape.jcr.query.model.NullOrder;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.Order;
import org.modeshape.jcr.query.model.Ordering;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.Query;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.Relike;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SameNodeJoinCondition;
import org.modeshape.jcr.query.model.Selector;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.model.SetQuery;
import org.modeshape.jcr.query.model.Source;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.Subquery;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.model.UpperCase;
import org.modeshape.jcr.query.parse.ColumnExpression;
import org.modeshape.jcr.query.parse.FullTextSearchParser;
import org.modeshape.jcr.query.parse.QueryParser;
import org.modeshape.jcr.value.ValueFormatException;

public class BasicSqlQueryParser
implements QueryParser {
    public static final String LANGUAGE = "SQL";

    @Override
    public String getLanguage() {
        return LANGUAGE;
    }

    public String toString() {
        return this.getLanguage();
    }

    public int hashCode() {
        return this.getLanguage().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryParser) {
            QueryParser that = (QueryParser)obj;
            return this.getLanguage().equals(that.getLanguage());
        }
        return false;
    }

    @Override
    public QueryCommand parseQuery(String query, TypeSystem typeSystem) {
        SqlTokenizer tokenizer = new SqlTokenizer(false);
        TokenStream tokens = new TokenStream(query, (TokenStream.Tokenizer)tokenizer, false);
        tokens.start();
        return this.parseQueryCommand(tokens, typeSystem);
    }

    protected QueryCommand parseQueryCommand(TokenStream tokens, TypeSystem typeSystem) {
        QueryCommand command = null;
        if (tokens.matches("SELECT")) {
            command = this.parseQuery(tokens, typeSystem);
            while (tokens.hasNext()) {
                if (tokens.matchesAnyOf("UNION", new String[]{"INTERSECT", "EXCEPT"})) {
                    command = this.parseSetQuery(tokens, command, typeSystem);
                    continue;
                }
                if (!tokens.matches(')')) {
                    Position pos = tokens.previousPosition();
                    String msg = GraphI18n.unexpectedToken.text(new Object[]{tokens.consume(), pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                break;
            }
        } else {
            Position pos = tokens.nextPosition();
            String msg = GraphI18n.unexpectedToken.text(new Object[]{tokens.consume(), pos.getLine(), pos.getColumn()});
            throw new ParsingException(pos, msg);
        }
        return command;
    }

    protected Query parseQuery(TokenStream tokens, TypeSystem typeSystem) {
        AtomicBoolean isDistinct = new AtomicBoolean(false);
        List<ColumnExpression> columnExpressions = this.parseSelect(tokens, isDistinct, typeSystem);
        Source source = this.parseFrom(tokens, typeSystem);
        Constraint constraint = this.parseWhere(tokens, typeSystem, source);
        List<Ordering> orderings = this.parseOrderBy(tokens, typeSystem, source);
        Limit limit = this.parseLimit(tokens);
        if (orderings == null) {
            this.parseOrderBy(tokens, typeSystem, source);
        }
        ArrayList<Column> columns = new ArrayList<Column>(columnExpressions.size());
        for (ColumnExpression expression : columnExpressions) {
            SelectorName selectorName = expression.getSelectorName();
            String propertyName = expression.getPropertyName();
            if (selectorName == null) {
                if (source instanceof Selector) {
                    selectorName = ((Selector)source).aliasOrName();
                } else {
                    Position pos = expression.getPosition();
                    String msg = GraphI18n.mustBeScopedAtLineAndColumn.text(new Object[]{expression, pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
            }
            columns.add(this.column(selectorName, propertyName, expression.getColumnName()));
        }
        return this.query(source, constraint, orderings, columns, limit, isDistinct.get());
    }

    protected SetQuery parseSetQuery(TokenStream tokens, QueryCommand leftHandSide, TypeSystem typeSystem) {
        SetQuery.Operation operation = null;
        if (tokens.canConsume("UNION")) {
            operation = SetQuery.Operation.UNION;
        } else if (tokens.canConsume("INTERSECT")) {
            operation = SetQuery.Operation.INTERSECT;
        } else {
            tokens.consume("EXCEPT");
            operation = SetQuery.Operation.EXCEPT;
        }
        boolean all = tokens.canConsume("ALL");
        Query rightQuery = this.parseQuery(tokens, typeSystem);
        return this.setQuery(leftHandSide, operation, rightQuery, all);
    }

    protected List<ColumnExpression> parseSelect(TokenStream tokens, AtomicBoolean isDistinct, TypeSystem typeSystem) {
        tokens.consume("SELECT");
        if (tokens.canConsume("DISTINCT")) {
            isDistinct.set(true);
        }
        if (tokens.canConsume('*')) {
            return Collections.emptyList();
        }
        ArrayList<ColumnExpression> columns = new ArrayList<ColumnExpression>();
        do {
            Position position = tokens.nextPosition();
            String propertyName = this.parseName(tokens, typeSystem);
            SelectorName selectorName = null;
            if (tokens.canConsume('.')) {
                selectorName = new SelectorName(propertyName);
                propertyName = this.parseName(tokens, typeSystem);
            }
            String alias = propertyName;
            if (tokens.canConsume("AS")) {
                alias = this.parseName(tokens, typeSystem);
            }
            columns.add(new ColumnExpression(selectorName, propertyName, alias, position));
        } while (tokens.canConsume(','));
        return columns;
    }

    protected Source parseFrom(TokenStream tokens, TypeSystem typeSystem) {
        Source source = null;
        tokens.consume("FROM");
        source = this.parseNamedSelector(tokens, typeSystem);
        while (tokens.hasNext()) {
            JoinType joinType = null;
            if (tokens.canConsume("JOIN") || tokens.canConsume("INNER", new String[]{"JOIN"})) {
                joinType = JoinType.INNER;
            } else if (tokens.canConsume("OUTER", new String[]{"JOIN"}) || tokens.canConsume("LEFT", new String[]{"JOIN"}) || tokens.canConsume("LEFT", new String[]{"OUTER", "JOIN"})) {
                joinType = JoinType.LEFT_OUTER;
            } else if (tokens.canConsume("RIGHT", new String[]{"OUTER", "JOIN"}) || tokens.canConsume("RIGHT", new String[]{"OUTER"})) {
                joinType = JoinType.RIGHT_OUTER;
            } else if (tokens.canConsume("FULL", new String[]{"OUTER", "JOIN"}) || tokens.canConsume("FULL", new String[]{"OUTER"})) {
                joinType = JoinType.FULL_OUTER;
            } else if (tokens.canConsume("CROSS", new String[]{"JOIN"}) || tokens.canConsume("CROSS")) {
                joinType = JoinType.CROSS;
            }
            if (joinType == null) break;
            NamedSelector right = this.parseNamedSelector(tokens, typeSystem);
            JoinCondition joinCondition = this.parseJoinCondition(tokens, typeSystem);
            source = this.join(source, joinType, right, joinCondition);
        }
        return source;
    }

    protected JoinCondition parseJoinCondition(TokenStream tokens, TypeSystem typeSystem) {
        tokens.consume("ON");
        if (tokens.canConsume("ISSAMENODE", new String[]{"("})) {
            SelectorName selector1Name = this.parseSelectorName(tokens, typeSystem);
            tokens.consume(',');
            SelectorName selector2Name = this.parseSelectorName(tokens, typeSystem);
            if (tokens.canConsume(',')) {
                String path = this.parsePath(tokens, typeSystem);
                tokens.consume(')');
                return this.sameNodeJoinCondition(selector1Name, selector2Name, path);
            }
            tokens.consume(')');
            return this.sameNodeJoinCondition(selector1Name, selector2Name);
        }
        if (tokens.canConsume("ISCHILDNODE", new String[]{"("})) {
            SelectorName child = this.parseSelectorName(tokens, typeSystem);
            tokens.consume(',');
            SelectorName parent = this.parseSelectorName(tokens, typeSystem);
            tokens.consume(')');
            return this.childNodeJoinCondition(parent, child);
        }
        if (tokens.canConsume("ISDESCENDANTNODE", new String[]{"("})) {
            SelectorName descendant = this.parseSelectorName(tokens, typeSystem);
            tokens.consume(',');
            SelectorName ancestor = this.parseSelectorName(tokens, typeSystem);
            tokens.consume(')');
            return this.descendantNodeJoinCondition(ancestor, descendant);
        }
        SelectorName selector1 = this.parseSelectorName(tokens, typeSystem);
        tokens.consume('.');
        String property1 = this.parseName(tokens, typeSystem);
        tokens.consume('=');
        SelectorName selector2 = this.parseSelectorName(tokens, typeSystem);
        tokens.consume('.');
        String property2 = this.parseName(tokens, typeSystem);
        return this.equiJoinCondition(selector1, property1, selector2, property2);
    }

    protected Constraint parseWhere(TokenStream tokens, TypeSystem typeSystem, Source source) {
        if (tokens.canConsume("WHERE")) {
            return this.parseConstraint(tokens, typeSystem, source);
        }
        return null;
    }

    protected Constraint parseConstraint(TokenStream tokens, TypeSystem typeSystem, Source source) {
        Constraint rhs;
        String path;
        SelectorName selectorName;
        Constraint constraint = null;
        Position pos = tokens.nextPosition();
        if (tokens.canConsume("(")) {
            constraint = this.parseConstraint(tokens, typeSystem, source);
            tokens.consume(")");
        } else if (tokens.canConsume("NOT")) {
            tokens.canConsume('(');
            constraint = this.not(this.parseConstraint(tokens, typeSystem, source));
            tokens.canConsume(')');
        } else if (tokens.canConsume("CONTAINS", new String[]{"("})) {
            String first = tokens.consume();
            SelectorName selectorName2 = null;
            String propertyName = null;
            Position position = tokens.previousPosition();
            if (first.equalsIgnoreCase(".")) {
                selectorName2 = ((Selector)source).aliasOrName();
            } else if (tokens.canConsume(".", new String[]{"*"})) {
                selectorName2 = new SelectorName(this.removeBracketsAndQuotes(first, position));
            } else if (tokens.canConsume('.')) {
                selectorName2 = new SelectorName(this.removeBracketsAndQuotes(first, position));
                propertyName = this.parseName(tokens, typeSystem);
            } else {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"CONTAINS()", pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName2 = ((Selector)source).aliasOrName();
                propertyName = this.removeBracketsAndQuotes(first, position);
            }
            tokens.consume(',');
            if (tokens.canConsume('$')) {
                BindVariableName var = this.parseBindVariableName(tokens, typeSystem);
                try {
                    constraint = this.fullTextSearch(selectorName2, propertyName, var);
                }
                catch (RepositoryException e) {
                    String msg = GraphI18n.functionHasInvalidBindVariable.text(new Object[]{"CONTAINS()", pos.getLine(), pos.getColumn(), var});
                    throw new ParsingException(pos, msg);
                }
            } else {
                String expression = this.removeBracketsAndQuotes(tokens.consume(), false, tokens.previousPosition());
                FullTextSearch.Term term = this.parseFullTextSearchExpression(expression, tokens.previousPosition());
                constraint = this.fullTextSearch(selectorName2, propertyName, expression, term);
            }
            tokens.consume(")");
        } else if (tokens.canConsume("ISSAMENODE", new String[]{"("})) {
            selectorName = null;
            if (tokens.matches("any value", new String[]{")"})) {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"ISSAMENODE()", pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName = ((Selector)source).name();
            } else {
                selectorName = this.parseSelectorName(tokens, typeSystem);
                tokens.consume(',');
            }
            path = this.parsePath(tokens, typeSystem);
            tokens.consume(')');
            constraint = this.sameNode(selectorName, path);
        } else if (tokens.canConsume("ISCHILDNODE", new String[]{"("})) {
            selectorName = null;
            if (tokens.matches("any value", new String[]{")"})) {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"ISCHILDNODE()", pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName = ((Selector)source).name();
            } else {
                selectorName = this.parseSelectorName(tokens, typeSystem);
                tokens.consume(',');
            }
            path = this.parsePath(tokens, typeSystem);
            tokens.consume(')');
            constraint = this.childNode(selectorName, path);
        } else if (tokens.canConsume("ISDESCENDANTNODE", new String[]{"("})) {
            selectorName = null;
            if (tokens.matches("any value", new String[]{")"})) {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"ISDESCENDANTNODE()", pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName = ((Selector)source).name();
            } else {
                selectorName = this.parseSelectorName(tokens, typeSystem);
                tokens.consume(',');
            }
            path = this.parsePath(tokens, typeSystem);
            tokens.consume(')');
            constraint = this.descendantNode(selectorName, path);
        } else if (tokens.canConsume("RELIKE", new String[]{"("})) {
            StaticOperand left = this.parseStaticOperand(tokens, typeSystem);
            tokens.consume(',');
            PropertyValue right = this.parsePropertyValue(tokens, typeSystem, source);
            tokens.consume(')');
            constraint = new Relike(left, right);
        } else {
            DynamicOperand left;
            Position pos2 = tokens.nextPosition();
            constraint = this.parsePropertyExistance(tokens, typeSystem, source);
            if (constraint == null && (left = this.parseDynamicOperand(tokens, typeSystem, source)) != null) {
                StaticOperand right;
                if (tokens.matches('(') && left instanceof PropertyValue) {
                    String name = ((PropertyValue)left).getPropertyName();
                    String msg = GraphI18n.expectingConstraintCondition.text(new Object[]{name, pos2.getLine(), pos2.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                if (tokens.matches("IN", new String[]{"("}) || tokens.matches("NOT", new String[]{"IN", "("})) {
                    boolean not = tokens.canConsume("NOT");
                    List<StaticOperand> staticOperands = this.parseInClause(tokens, typeSystem);
                    constraint = this.setCriteria(left, staticOperands);
                    if (not) {
                        constraint = this.not(constraint);
                    }
                } else if (tokens.matches("BETWEEN") || tokens.matches("NOT", new String[]{"BETWEEN"})) {
                    boolean not = tokens.canConsume("NOT");
                    tokens.consume("BETWEEN");
                    StaticOperand lowerBound = this.parseStaticOperand(tokens, typeSystem);
                    boolean lowerInclusive = !tokens.canConsume("EXCLUSIVE");
                    tokens.consume("AND");
                    StaticOperand upperBound = this.parseStaticOperand(tokens, typeSystem);
                    boolean upperInclusive = !tokens.canConsume("EXCLUSIVE");
                    constraint = this.between(left, lowerBound, upperBound, lowerInclusive, upperInclusive);
                    if (not) {
                        constraint = this.not(constraint);
                    }
                } else if (tokens.matches("NOT", new String[]{"LIKE"})) {
                    tokens.consume("NOT");
                    Operator operator = this.parseComparisonOperator(tokens);
                    right = this.parseStaticOperand(tokens, typeSystem);
                    constraint = this.comparison(left, operator, right);
                    constraint = this.not(constraint);
                } else {
                    Operator operator = this.parseComparisonOperator(tokens);
                    right = this.parseStaticOperand(tokens, typeSystem);
                    constraint = this.comparison(left, operator, right);
                }
            }
        }
        if (constraint == null) {
            String msg = GraphI18n.expectingConstraintCondition.text(new Object[]{tokens.consume(), pos.getLine(), pos.getColumn()});
            throw new ParsingException(pos, msg);
        }
        while (tokens.canConsume("AND")) {
            rhs = this.parseConstraint(tokens, typeSystem, source);
            if (rhs == null) continue;
            constraint = this.and(constraint, rhs);
        }
        while (tokens.canConsume("OR")) {
            rhs = this.parseConstraint(tokens, typeSystem, source);
            if (rhs == null) continue;
            constraint = this.or(constraint, rhs);
        }
        return constraint;
    }

    protected List<StaticOperand> parseInClause(TokenStream tokens, TypeSystem typeSystem) {
        ArrayList<StaticOperand> result = new ArrayList<StaticOperand>();
        tokens.consume("IN");
        tokens.consume("(");
        if (!tokens.canConsume(")")) {
            do {
                result.add(this.parseStaticOperand(tokens, typeSystem));
            } while (tokens.canConsume(','));
            tokens.consume(")");
        }
        return result;
    }

    protected FullTextSearch.Term parseFullTextSearchExpression(String expression, Position startOfExpression) {
        try {
            return new FullTextSearchParser().parse(expression);
        }
        catch (ParsingException e) {
            Position queryPos = startOfExpression.add(e.getPosition());
            throw new ParsingException(queryPos, e.getMessage());
        }
    }

    protected Operator parseComparisonOperator(TokenStream tokens) {
        if (tokens.canConsume("=")) {
            return Operator.EQUAL_TO;
        }
        if (tokens.canConsume("LIKE")) {
            return Operator.LIKE;
        }
        if (tokens.canConsume("!", new String[]{"="})) {
            return Operator.NOT_EQUAL_TO;
        }
        if (tokens.canConsume("<", new String[]{">"})) {
            return Operator.NOT_EQUAL_TO;
        }
        if (tokens.canConsume("<", new String[]{"="})) {
            return Operator.LESS_THAN_OR_EQUAL_TO;
        }
        if (tokens.canConsume(">", new String[]{"="})) {
            return Operator.GREATER_THAN_OR_EQUAL_TO;
        }
        if (tokens.canConsume("<")) {
            return Operator.LESS_THAN;
        }
        if (tokens.canConsume(">")) {
            return Operator.GREATER_THAN;
        }
        Position pos = tokens.nextPosition();
        String msg = GraphI18n.expectingComparisonOperator.text(new Object[]{tokens.consume(), pos.getLine(), pos.getColumn()});
        throw new ParsingException(pos, msg);
    }

    protected List<Ordering> parseOrderBy(TokenStream tokens, TypeSystem typeSystem, Source source) {
        if (tokens.canConsume("ORDER", new String[]{"BY"})) {
            ArrayList<Ordering> orderings = new ArrayList<Ordering>();
            do {
                orderings.add(this.parseOrdering(tokens, typeSystem, source));
            } while (tokens.canConsume(','));
            return orderings;
        }
        return null;
    }

    protected Ordering parseOrdering(TokenStream tokens, TypeSystem typeSystem, Source source) {
        DynamicOperand operand = this.parseDynamicOperand(tokens, typeSystem, source);
        Order order = Order.ASCENDING;
        if (tokens.canConsume("DESC")) {
            order = Order.DESCENDING;
        }
        if (tokens.canConsume("ASC")) {
            order = Order.ASCENDING;
        }
        NullOrder nullOrder = NullOrder.defaultOrder(order);
        if (tokens.canConsume("NULLS", new String[]{"FIRST"})) {
            nullOrder = NullOrder.NULLS_FIRST;
        }
        if (tokens.canConsume("NULLS", new String[]{"LAST"})) {
            nullOrder = NullOrder.NULLS_LAST;
        }
        return this.ordering(operand, order, nullOrder);
    }

    protected Constraint parsePropertyExistance(TokenStream tokens, TypeSystem typeSystem, Source source) {
        if (tokens.matches("any value", new String[]{".", "any value", "IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{".", "any value", "IS", "NULL"}) || tokens.matches("any value", new String[]{"IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{"IS", "NULL"})) {
            Position pos = tokens.nextPosition();
            String firstWord = tokens.consume();
            SelectorName selectorName = null;
            String propertyName = null;
            if (tokens.canConsume('.')) {
                selectorName = new SelectorName(firstWord);
                propertyName = this.parseName(tokens, typeSystem);
            } else {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.mustBeScopedAtLineAndColumn.text(new Object[]{firstWord, pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName = ((Selector)source).name();
                propertyName = this.parseName(firstWord, typeSystem, pos);
            }
            if (tokens.canConsume("IS", new String[]{"NOT", "NULL"})) {
                return this.propertyExistence(selectorName, propertyName);
            }
            tokens.consume("IS", new String[]{"NULL"});
            return this.not(this.propertyExistence(selectorName, propertyName));
        }
        return null;
    }

    protected StaticOperand parseStaticOperand(TokenStream tokens, TypeSystem typeSystem) {
        if (tokens.canConsume('$')) {
            return this.parseBindVariableName(tokens, typeSystem);
        }
        if (tokens.canConsume('(')) {
            StaticOperand result = this.parseStaticOperand(tokens, typeSystem);
            tokens.consume(')');
            return result;
        }
        if (tokens.matches("SELECT")) {
            QueryCommand subqueryExpression = this.parseQueryCommand(tokens, typeSystem);
            return this.subquery(subqueryExpression);
        }
        return this.parseLiteral(tokens, typeSystem);
    }

    protected BindVariableName parseBindVariableName(TokenStream tokens, TypeSystem typeSystem) {
        String value = tokens.consume();
        if (!XmlCharacters.isValidNcName((String)value)) {
            Position pos = tokens.previousPosition();
            String msg = GraphI18n.bindVariableMustConformToNcName.text(new Object[]{value, pos.getLine(), pos.getColumn()});
            throw new ParsingException(pos, msg);
        }
        return this.bindVariableName(value);
    }

    protected Subquery subquery(QueryCommand queryCommand) {
        return new Subquery(queryCommand);
    }

    protected Literal parseLiteral(TokenStream tokens, TypeSystem typeSystem) {
        if (tokens.canConsume("CAST", new String[]{"("})) {
            Position pos = tokens.nextPosition();
            Object value = this.parseLiteralValue(tokens, typeSystem);
            tokens.consume("AS");
            String typeName = tokens.consume();
            TypeSystem.TypeFactory<?> typeFactory = typeSystem.getTypeFactory(typeName);
            if (typeFactory == null) {
                Position typePos = tokens.previousPosition();
                String msg = GraphI18n.invalidPropertyType.text(new Object[]{tokens.consume(), typePos.getLine(), typePos.getColumn()});
                throw new ParsingException(typePos, msg);
            }
            tokens.consume(')');
            try {
                Object literal = typeFactory.create(value);
                return this.literal(typeSystem, literal);
            }
            catch (ValueFormatException e) {
                String msg = GraphI18n.valueCannotBeCastToSpecifiedType.text(new Object[]{value, pos.getLine(), pos.getColumn(), typeFactory.getTypeName(), e.getMessage()});
                throw new ParsingException(pos, msg);
            }
        }
        return this.literal(typeSystem, this.parseLiteralValue(tokens, typeSystem));
    }

    protected Object parseLiteralValue(TokenStream tokens, TypeSystem typeSystem) {
        TypeSystem.TypeFactory<?> dateTimeFactory;
        if (tokens.matches(4)) {
            return this.removeBracketsAndQuotes(tokens.consume(), tokens.previousPosition());
        }
        TypeSystem.TypeFactory<Boolean> booleanFactory = typeSystem.getBooleanFactory();
        if (booleanFactory != null) {
            if (tokens.canConsume("TRUE")) {
                return booleanFactory.create(Boolean.TRUE);
            }
            if (tokens.canConsume("FALSE")) {
                return booleanFactory.create(Boolean.FALSE);
            }
        }
        Position pos = tokens.nextPosition();
        String sign = "";
        if (tokens.canConsume('-')) {
            sign = "-";
        } else if (tokens.canConsume('+')) {
            sign = "";
        }
        String integral = tokens.consume();
        TypeSystem.TypeFactory<Double> doubleFactory = typeSystem.getDoubleFactory();
        if (doubleFactory != null) {
            String decimal = null;
            if (tokens.canConsume('.')) {
                decimal = tokens.consume();
                String value = sign + integral + "." + decimal;
                if ((decimal.endsWith("e") || decimal.endsWith("E")) && (tokens.matches('+') || tokens.matches('-'))) {
                    value = value + tokens.consume() + tokens.consume();
                }
                try {
                    return doubleFactory.create(value);
                }
                catch (ValueFormatException e) {
                    String msg = GraphI18n.expectingLiteralAndUnableToParseAsDouble.text(new Object[]{value, pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
            }
        }
        if ((dateTimeFactory = typeSystem.getDateTimeFactory()) != null && tokens.canConsume('-')) {
            String year = integral;
            String month = tokens.consume();
            tokens.consume('-');
            String dateAndHour = tokens.consume();
            tokens.consume(':');
            String minutes = tokens.consume();
            tokens.consume(':');
            String seconds = tokens.consume();
            tokens.consume('.');
            String subSeconds = tokens.consume();
            String tzSign = "+";
            String tzHours = "00";
            String tzMinutes = "00";
            String tzDelim = ":";
            if (tokens.canConsume('+')) {
                tzHours = tokens.consume();
                if (tokens.canConsume(':')) {
                    tzMinutes = tokens.consume();
                }
            } else if (tokens.canConsume('-')) {
                tzSign = "-";
                tzHours = tokens.consume();
                if (tokens.canConsume(':')) {
                    tzMinutes = tokens.consume();
                }
            } else if (tokens.canConsume(':')) {
                tzSign = "";
                tzHours = "";
                if (tokens.canConsume(':')) {
                    tzMinutes = tokens.consume();
                }
            } else if (subSeconds.endsWith("Z")) {
                tzHours = "";
                tzDelim = "";
                tzMinutes = "";
                tzSign = "";
            } else if (subSeconds.endsWith("UTC")) {
                subSeconds = subSeconds.length() > 3 ? subSeconds.substring(0, subSeconds.length() - 3) : subSeconds;
            }
            String value = sign + year + "-" + month + "-" + dateAndHour + ":" + minutes + ":" + seconds + "." + subSeconds + tzSign + tzHours + tzDelim + tzMinutes;
            try {
                Object dateTime = dateTimeFactory.create(value);
                return dateTimeFactory.asString(dateTime);
            }
            catch (ValueFormatException e) {
                String msg = GraphI18n.expectingLiteralAndUnableToParseAsDate.text(new Object[]{value, pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
        }
        TypeSystem.TypeFactory<Long> longFactory = typeSystem.getLongFactory();
        String value = sign + integral;
        try {
            return longFactory.create(value);
        }
        catch (ValueFormatException e) {
            String msg = GraphI18n.expectingLiteralAndUnableToParseAsLong.text(new Object[]{value, pos.getLine(), pos.getColumn()});
            throw new ParsingException(pos, msg);
        }
    }

    protected DynamicOperand parseDynamicOperand(TokenStream tokens, TypeSystem typeSystem, Source source) {
        DynamicOperand result = null;
        Position pos = tokens.nextPosition();
        if (tokens.canConsume('(')) {
            result = this.parseDynamicOperand(tokens, typeSystem, source);
            tokens.consume(")");
        } else if (tokens.canConsume("LENGTH", new String[]{"("})) {
            result = this.length(this.parsePropertyValue(tokens, typeSystem, source));
            tokens.consume(")");
        } else if (tokens.canConsume("LOWER", new String[]{"("})) {
            result = this.lowerCase(this.parseDynamicOperand(tokens, typeSystem, source));
            tokens.consume(")");
        } else if (tokens.canConsume("UPPER", new String[]{"("})) {
            result = this.upperCase(this.parseDynamicOperand(tokens, typeSystem, source));
            tokens.consume(")");
        } else if (tokens.canConsume("NAME", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return this.nodeName(((Selector)source).name());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"NAME()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = this.nodeName(this.parseSelectorName(tokens, typeSystem));
            tokens.consume(")");
        } else if (tokens.canConsume("LOCALNAME", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return this.nodeLocalName(((Selector)source).name());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"LOCALNAME()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = this.nodeLocalName(this.parseSelectorName(tokens, typeSystem));
            tokens.consume(")");
        } else if (tokens.canConsume("SCORE", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return this.fullTextSearchScore(((Selector)source).name());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"SCORE()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = this.fullTextSearchScore(this.parseSelectorName(tokens, typeSystem));
            tokens.consume(")");
        } else if (tokens.canConsume("DEPTH", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return this.nodeDepth(((Selector)source).name());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"DEPTH()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = this.nodeDepth(this.parseSelectorName(tokens, typeSystem));
            tokens.consume(")");
        } else if (tokens.canConsume("ID", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return this.nodeId(((Selector)source).name());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"ID()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = this.nodeId(this.parseSelectorName(tokens, typeSystem));
            tokens.consume(")");
        } else if (tokens.canConsume("PATH", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return this.nodePath(((Selector)source).name());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"PATH()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = this.nodePath(this.parseSelectorName(tokens, typeSystem));
            tokens.consume(")");
        } else if (tokens.canConsume("CHILDCOUNT", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return this.childCount(((Selector)source).name());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"CHILDCOUNT()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = this.childCount(this.parseSelectorName(tokens, typeSystem));
            tokens.consume(")");
        } else {
            result = tokens.canConsume("REFERENCE", new String[]{"("}) ? this.parseReferenceValue(tokens, typeSystem, source) : this.parsePropertyValue(tokens, typeSystem, source);
        }
        ArithmeticOperator arithmeticOperator = null;
        if (tokens.canConsume('+')) {
            arithmeticOperator = ArithmeticOperator.ADD;
        } else if (tokens.canConsume('-')) {
            arithmeticOperator = ArithmeticOperator.SUBTRACT;
        } else if (tokens.canConsume('*')) {
            arithmeticOperator = ArithmeticOperator.MULTIPLY;
        } else if (tokens.canConsume('/')) {
            arithmeticOperator = ArithmeticOperator.DIVIDE;
        }
        if (arithmeticOperator != null) {
            if (tokens.matches('(')) {
                DynamicOperand right = this.parseDynamicOperand(tokens, typeSystem, source);
                result = this.arithmeticOperand(result, arithmeticOperator, right);
            } else {
                DynamicOperand right = this.parseDynamicOperand(tokens, typeSystem, source);
                if (right instanceof ArithmeticOperand) {
                    ArithmeticOperand arithRhs = (ArithmeticOperand)right;
                    ArithmeticOperator rhsOperator = arithRhs.operator();
                    if (arithmeticOperator.precedes(rhsOperator)) {
                        DynamicOperand newRhs = arithRhs.getRight();
                        ArithmeticOperand newLhs = new ArithmeticOperand(result, arithmeticOperator, arithRhs.getLeft());
                        result = this.arithmeticOperand(newLhs, rhsOperator, newRhs);
                    } else {
                        result = this.arithmeticOperand(result, arithmeticOperator, right);
                    }
                } else {
                    result = this.arithmeticOperand(result, arithmeticOperator, right);
                }
            }
        }
        return result;
    }

    protected PropertyValue parsePropertyValue(TokenStream tokens, TypeSystem typeSystem, Source source) {
        Position pos = tokens.nextPosition();
        String firstWord = this.parseName(tokens, typeSystem);
        SelectorName selectorName = null;
        if (tokens.canConsume('.')) {
            selectorName = new SelectorName(firstWord);
            String propertyName = this.parseName(tokens, typeSystem);
            return this.propertyValue(selectorName, propertyName);
        }
        if (source instanceof Selector) {
            selectorName = ((Selector)source).aliasOrName();
            return this.propertyValue(selectorName, firstWord);
        }
        String msg = GraphI18n.mustBeScopedAtLineAndColumn.text(new Object[]{firstWord, pos.getLine(), pos.getColumn()});
        throw new ParsingException(pos, msg);
    }

    protected ReferenceValue parseReferenceValue(TokenStream tokens, TypeSystem typeSystem, Source source) {
        Position pos = tokens.nextPosition();
        SelectorName selectorName = null;
        if (tokens.canConsume(')')) {
            if (source instanceof Selector) {
                selectorName = ((Selector)source).aliasOrName();
                return this.referenceValue(selectorName);
            }
            String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"REFERENCE()", pos.getLine(), pos.getColumn()});
            throw new ParsingException(pos, msg);
        }
        String firstWord = this.parseName(tokens, typeSystem);
        if (tokens.canConsume('.')) {
            selectorName = new SelectorName(firstWord);
            String propertyName = this.parseName(tokens, typeSystem);
            return this.referenceValue(selectorName, propertyName);
        }
        tokens.consume(")");
        if (source instanceof Selector) {
            selectorName = new SelectorName(firstWord);
            Selector selector = (Selector)source;
            if (selectorName.equals(selector.name()) || selector.hasAlias() && selectorName.equals(selector.alias())) {
                return this.referenceValue(selectorName);
            }
            return this.referenceValue(selector.aliasOrName(), firstWord);
        }
        selectorName = new SelectorName(firstWord);
        return this.referenceValue(selectorName);
    }

    protected Limit parseLimit(TokenStream tokens) {
        if (tokens.canConsume("LIMIT")) {
            int first = tokens.consumeInteger();
            if (tokens.canConsume(',')) {
                int to = tokens.consumeInteger();
                int offset = to - first;
                if (offset < 0) {
                    Position pos = tokens.previousPosition();
                    String msg = GraphI18n.secondValueInLimitRangeCannotBeLessThanFirst.text(new Object[]{first, to, pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                return this.limit(offset, first);
            }
            if (tokens.canConsume("OFFSET")) {
                int offset = tokens.consumeInteger();
                return this.limit(first, offset);
            }
            return this.limit(first, 0);
        }
        if (tokens.canConsume("OFFSET")) {
            int offset = tokens.consumeInteger();
            return this.limit(Integer.MAX_VALUE, offset);
        }
        return null;
    }

    protected String removeBracketsAndQuotes(String text, Position position) {
        return this.removeBracketsAndQuotes(text, true, position);
    }

    protected String removeBracketsAndQuotes(String text, boolean recursive, Position position) {
        if (text.length() > 0) {
            char firstChar = text.charAt(0);
            switch (firstChar) {
                case '\"': 
                case '\'': {
                    if (text.charAt(text.length() - 1) != firstChar) {
                        String msg = GraphI18n.expectingValidName.text(new Object[]{text, position.getLine(), position.getColumn()});
                        throw new ParsingException(position, msg);
                    }
                    String removed = text.substring(1, text.length() - 1);
                    return recursive ? this.removeBracketsAndQuotes(removed, recursive, position) : removed;
                }
                case '[': {
                    if (text.charAt(text.length() - 1) != ']') {
                        String msg = GraphI18n.expectingValidName.text(new Object[]{text, position.getLine(), position.getColumn()});
                        throw new ParsingException(position, msg);
                    }
                    String removed = text.substring(1, text.length() - 1);
                    return recursive ? this.removeBracketsAndQuotes(removed, recursive, position) : removed;
                }
            }
        }
        return text;
    }

    protected NamedSelector parseNamedSelector(TokenStream tokens, TypeSystem typeSystem) {
        SelectorName name = this.parseSelectorName(tokens, typeSystem);
        SelectorName alias = null;
        if (tokens.canConsume("AS")) {
            alias = this.parseSelectorName(tokens, typeSystem);
        }
        return new NamedSelector(name, alias);
    }

    protected SelectorName parseSelectorName(TokenStream tokens, TypeSystem typeSystem) {
        return new SelectorName(this.parseName(tokens, typeSystem));
    }

    protected String parsePath(TokenStream tokens, TypeSystem typeSystem) {
        return this.removeBracketsAndQuotes(tokens.consume(), tokens.previousPosition());
    }

    protected String parseName(TokenStream tokens, TypeSystem typeSystem) {
        return this.removeBracketsAndQuotes(tokens.consume(), tokens.previousPosition());
    }

    protected String parseName(String token, TypeSystem typeSystem, Position position) {
        return this.removeBracketsAndQuotes(token, position);
    }

    protected Query query(Source source, Constraint constraint, List<? extends Ordering> orderings, List<? extends Column> columns, Limit limit, boolean distinct) {
        return new Query(source, constraint, orderings, columns, limit, distinct);
    }

    protected SetQuery setQuery(QueryCommand leftQuery, SetQuery.Operation operation, QueryCommand rightQuery, boolean all) {
        return new SetQuery(leftQuery, operation, rightQuery, all);
    }

    protected Length length(PropertyValue propertyValue) {
        return new Length(propertyValue);
    }

    protected LowerCase lowerCase(DynamicOperand operand) {
        return new LowerCase(operand);
    }

    protected UpperCase upperCase(DynamicOperand operand) {
        return new UpperCase(operand);
    }

    protected NodeName nodeName(SelectorName selector) {
        return new NodeName(selector);
    }

    protected NodeLocalName nodeLocalName(SelectorName selector) {
        return new NodeLocalName(selector);
    }

    protected NodeDepth nodeDepth(SelectorName selector) {
        return new NodeDepth(selector);
    }

    protected NodeId nodeId(SelectorName selector) {
        return new NodeId(selector);
    }

    protected NodePath nodePath(SelectorName selector) {
        return new NodePath(selector);
    }

    protected ChildCount childCount(SelectorName selector) {
        return new ChildCount(selector);
    }

    protected EquiJoinCondition equiJoinCondition(SelectorName selector1, String property1, SelectorName selector2, String property2) {
        return new EquiJoinCondition(selector1, property1, selector2, property2);
    }

    protected DescendantNodeJoinCondition descendantNodeJoinCondition(SelectorName ancestor, SelectorName descendant) {
        return new DescendantNodeJoinCondition(ancestor, descendant);
    }

    protected ChildNodeJoinCondition childNodeJoinCondition(SelectorName parent, SelectorName child) {
        return new ChildNodeJoinCondition(parent, child);
    }

    protected SameNodeJoinCondition sameNodeJoinCondition(SelectorName selector1, SelectorName selector2) {
        return new SameNodeJoinCondition(selector1, selector2);
    }

    protected SameNodeJoinCondition sameNodeJoinCondition(SelectorName selector1, SelectorName selector2, String path) {
        return new SameNodeJoinCondition(selector1, selector2, path);
    }

    protected Limit limit(int rowCount, int offset) {
        return new Limit(rowCount, offset);
    }

    protected Column column(SelectorName selectorName, String propertyName, String columnName) {
        return new Column(selectorName, propertyName, columnName);
    }

    protected Join join(Source left, JoinType joinType, Source right, JoinCondition joinCondition) {
        return new Join(left, joinType, right, joinCondition);
    }

    protected Not not(Constraint constraint) {
        return new Not(constraint);
    }

    protected And and(Constraint constraint1, Constraint constraint2) {
        return new And(constraint1, constraint2);
    }

    protected Or or(Constraint constraint1, Constraint constraint2) {
        return new Or(constraint1, constraint2);
    }

    protected Between between(DynamicOperand operand, StaticOperand lowerBound, StaticOperand upperBound, boolean lowerInclusive, boolean upperInclusive) {
        return new Between(operand, lowerBound, upperBound, lowerInclusive, upperInclusive);
    }

    protected SetCriteria setCriteria(DynamicOperand operand, Collection<? extends StaticOperand> values) {
        return new SetCriteria(operand, values);
    }

    protected FullTextSearch fullTextSearch(SelectorName name, String propertyName, String expression, FullTextSearch.Term term) {
        return new FullTextSearch(name, propertyName, expression, term);
    }

    protected FullTextSearch fullTextSearch(SelectorName name, String propertyName, StaticOperand expression) throws RepositoryException {
        return new FullTextSearch(name, propertyName, expression, null);
    }

    protected SameNode sameNode(SelectorName name, String path) {
        return new SameNode(name, path);
    }

    protected ChildNode childNode(SelectorName name, String path) {
        return new ChildNode(name, path);
    }

    protected DescendantNode descendantNode(SelectorName name, String path) {
        return new DescendantNode(name, path);
    }

    protected Comparison comparison(DynamicOperand left, Operator operator, StaticOperand right) {
        return new Comparison(left, operator, right);
    }

    protected Ordering ordering(DynamicOperand operand, Order order, NullOrder nullOrder) {
        return new Ordering(operand, order, nullOrder);
    }

    protected PropertyExistence propertyExistence(SelectorName selector, String propertyName) {
        return new PropertyExistence(selector, propertyName);
    }

    protected FullTextSearchScore fullTextSearchScore(SelectorName selector) {
        return new FullTextSearchScore(selector);
    }

    protected ArithmeticOperand arithmeticOperand(DynamicOperand leftOperand, ArithmeticOperator operator, DynamicOperand rightOperand) {
        return new ArithmeticOperand(leftOperand, operator, rightOperand);
    }

    protected PropertyValue propertyValue(SelectorName selector, String propertyName) {
        return new PropertyValue(selector, propertyName);
    }

    protected ReferenceValue referenceValue(SelectorName selector) {
        return new ReferenceValue(selector);
    }

    protected ReferenceValue referenceValue(SelectorName selector, String propertyName) {
        return new ReferenceValue(selector, propertyName);
    }

    protected BindVariableName bindVariableName(String variableName) {
        return new BindVariableName(variableName);
    }

    protected Literal literal(TypeSystem typeSystem, Object value) throws ValueFormatException {
        return new Literal(value);
    }

    public static class SqlTokenizer
    implements TokenStream.Tokenizer {
        public static final int WORD = 1;
        public static final int SYMBOL = 2;
        public static final int OTHER = 3;
        public static final int QUOTED_STRING = 4;
        public static final int COMMENT = 6;
        private final boolean useComments;

        public SqlTokenizer(boolean useComments) {
            this.useComments = useComments;
        }

        public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
            block8: while (input.hasNext()) {
                char c = input.next();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    case '!': 
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '.': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case ']': 
                    case '{': 
                    case '|': 
                    case '}': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        break;
                    }
                    case '[': {
                        int startIndex = input.index();
                        char closingChar = ']';
                        Position pos = input.position(startIndex);
                        int numExpectedClosingQuoteChars = 1;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext(closingChar)) {
                                c = input.next();
                                continue;
                            }
                            if (c == '[') {
                                ++numExpectedClosingQuoteChars;
                                continue;
                            }
                            if (c != closingChar || --numExpectedClosingQuoteChars != 0) continue;
                        }
                        if (numExpectedClosingQuoteChars > 0) {
                            String msg = GraphI18n.noMatchingBracketFound.text(new Object[]{pos.getLine(), pos.getColumn()});
                            throw new ParsingException(pos, msg);
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(pos, startIndex, endIndex, 4);
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        int startIndex = input.index();
                        char closingChar = c;
                        Position pos = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext(closingChar)) {
                                c = input.next();
                                continue;
                            }
                            if (c != closingChar) continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = CommonI18n.noMatchingDoubleQuoteFound.text(new Object[]{pos.getLine(), pos.getColumn()});
                            if (closingChar == '\'') {
                                msg = CommonI18n.noMatchingSingleQuoteFound.text(new Object[]{pos.getLine(), pos.getColumn()});
                            }
                            throw new ParsingException(pos, msg);
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(pos, startIndex, endIndex, 4);
                        break;
                    }
                    case '-': {
                        int endIndex;
                        int startIndex = input.index();
                        Position pos = input.position(input.index());
                        if (input.isNext('-')) {
                            boolean foundLineTerminator = false;
                            while (input.hasNext()) {
                                c = input.next();
                                if (c != '\n' && c != '\r') continue;
                                foundLineTerminator = true;
                                break;
                            }
                            endIndex = input.index();
                            if (!foundLineTerminator) {
                                ++endIndex;
                            }
                            if (c == '\r' && input.isNext('\n')) {
                                input.next();
                            }
                            if (!this.useComments) continue block8;
                            tokens.addToken(pos, startIndex, endIndex, 6);
                            break;
                        }
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        break;
                    }
                    case '/': {
                        int endIndex;
                        int startIndex = input.index();
                        Position pos = input.position(input.index());
                        if (input.isNext('*')) {
                            while (input.hasNext() && !input.isNext('*', '/')) {
                                c = input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (!this.useComments) continue block8;
                            endIndex = input.index() + 1;
                            tokens.addToken(pos, startIndex, endIndex, 6);
                            break;
                        }
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        break;
                    }
                    default: {
                        int tokenType;
                        int startIndex = input.index();
                        Position pos = input.position(input.index());
                        int n = tokenType = Character.isLetterOrDigit(c) || c == '_' ? 1 : 3;
                        while (input.isNextLetterOrDigit() || input.isNext('_')) {
                            c = input.next();
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(pos, startIndex, endIndex, tokenType);
                    }
                }
            }
        }
    }
}

