/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.PhaseState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.json.JsonConverter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.json.StepStateJsonConverter;

public class BlockStateJsonConverter
extends JsonConverter<BlockState> {
    private boolean serialiseSteps;

    public BlockStateJsonConverter() {
        this(true);
    }

    public BlockStateJsonConverter(boolean serialiseSteps) {
        this.serialiseSteps = serialiseSteps;
    }

    @Override
    public JsonWriter writeJsonObject(BlockState block, JsonWriter writer) {
        writer.object();
        this.writeBlockBasics(block, writer);
        if (block instanceof CompositeBlockState) {
            this.writeJsonCompositeBlockState((CompositeBlockState)block, writer);
        } else if (block instanceof StepBlockState) {
            this.writeJsonStepBlockState((StepBlockState)block, writer);
        } else if (block instanceof PhaseContainerState) {
            this.writeJsonPhaseContainer((PhaseContainerState)block, writer);
        }
        writer.endObject();
        return writer;
    }

    private void writeJsonPhaseContainer(PhaseContainerState phaseContainerState, JsonWriter writer) {
        writer.key("root").value("true");
        Iterable blocks = phaseContainerState.getBlocks();
        if (blocks.iterator().hasNext()) {
            writer.key("blocks").array();
            for (PhaseState phase : blocks) {
                this.writePhase(phase, writer);
            }
            writer.endArray();
        }
    }

    public void writePhase(PhaseState phase, JsonWriter writer) {
        writer.object();
        this.writeBlockBasics((BlockState)phase, writer);
        writer.key("phase").value("true");
        writer.key("block");
        this.writeJsonObject(phase.getBlock(), writer);
        writer.endObject();
    }

    public void writeBlockBasics(BlockState block, JsonWriter writer) {
        writer.key("id").value(block.getId() == null ? "" : block.getId());
        writer.key("state").value(block.getState() == null ? null : block.getState().toString());
        writer.key("description").value(block.getDescription());
    }

    private void writeJsonStepBlockState(StepBlockState block, JsonWriter writer) {
        writer.key("currentStep").value(block.getCurrentStep());
        if (this.serialiseSteps && block.getSteps() != null && !block.getSteps().isEmpty()) {
            StepStateJsonConverter stepStateJsonConverter = new StepStateJsonConverter();
            writer.key("steps").array();
            for (StepState stepState : block.getSteps()) {
                stepStateJsonConverter.writeJsonObject(stepState, writer);
            }
            writer.endArray();
        }
    }

    private void writeJsonCompositeBlockState(CompositeBlockState block, JsonWriter writer) {
        writer.key("parallel").value(block.isParallel());
        if (block.getBlocks() != null && !block.getBlocks().isEmpty()) {
            writer.key("blocks").array();
            for (BlockState blockChild : block.getBlocks()) {
                this.writeJsonObject(blockChild, writer);
            }
            writer.endArray();
        }
    }
}

