/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.util.DevNull;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exploder {
    private static final Logger logger = LoggerFactory.getLogger(Exploder.class);

    public static void explode(ByteSource inputZip, File outputDirectory, MessageDigest sha1) throws IOException {
        Exploder.explode(inputZip, outputDirectory, sha1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void explode(ByteSource inputZip, File outputDirectory, MessageDigest sha1, boolean digestPaths) throws IOException {
        ZipInputStream zipEntryStream = null;
        try {
            ZipEntry entry;
            zipEntryStream = new ZipInputStream(inputZip.openStream());
            while ((entry = zipEntryStream.getNextEntry()) != null) {
                try {
                    File destinationDir;
                    if (sha1 != null) {
                        Exploder.digestEntryPath(sha1, entry, digestPaths);
                    }
                    if (entry.isDirectory()) {
                        File file = new File(outputDirectory, entry.getName());
                        if (file.exists()) continue;
                        Preconditions.checkState((boolean)file.mkdirs(), (String)"Could not create directory: %s", (Object[])new Object[]{entry.getName()});
                        continue;
                    }
                    File destinationFile = new File(outputDirectory, entry.getName());
                    String parentDirPath = destinationFile.getParent();
                    if (parentDirPath != null && !(destinationDir = new File(parentDirPath)).exists()) {
                        Preconditions.checkState((boolean)destinationDir.mkdirs(), (String)"Could not create directory: %s", (Object[])new Object[]{entry.getName()});
                    }
                    Preconditions.checkState((boolean)destinationFile.createNewFile(), (String)"Could not create file: %s", (Object[])new Object[]{entry.getName()});
                    FileOutputStream fo = new FileOutputStream(destinationFile);
                    try {
                        FilterInputStream from = zipEntryStream;
                        if (sha1 != null) {
                            from = new DigestInputStream(zipEntryStream, sha1);
                        }
                        ByteStreams.copy((InputStream)from, (OutputStream)fo);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)fo);
                    }
                }
                finally {
                    zipEntryStream.closeEntry();
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(zipEntryStream);
            throw throwable;
        }
        {
            catch (IOException exc) {
                try {
                    GuavaFiles.deleteRecursively(outputDirectory);
                    throw exc;
                }
                catch (Exception e) {
                    logger.error("Could not delete {}", (Object)outputDirectory, (Object)e);
                }
                throw exc;
                break;
            }
        }
        Closeables.closeQuietly((Closeable)zipEntryStream);
    }

    public static void calculateCheckSum(ByteSource inputZip, MessageDigest sha1) throws IOException {
        Exploder.calculateCheckSum(inputZip, sha1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calculateCheckSum(ByteSource inputZip, MessageDigest sha1, boolean digestPaths) throws IOException {
        ZipEntry entry;
        ZipInputStream zipEntryStream = null;
        try {
            zipEntryStream = new ZipInputStream(inputZip.openStream());
            while (true) {
                if ((entry = zipEntryStream.getNextEntry()) != null) break block8;
                break;
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(zipEntryStream);
            throw throwable;
        }
        {
            block8: {
                Closeables.closeQuietly((Closeable)zipEntryStream);
                return;
            }
            try {
                Exploder.digestEntryPath(sha1, entry, digestPaths);
                if (entry.isDirectory()) continue;
                ByteStreams.copy((InputStream)new DigestInputStream(zipEntryStream, sha1), (OutputStream)new DevNull());
                continue;
            }
            finally {
                zipEntryStream.closeEntry();
                continue;
            }
        }
    }

    private static void digestEntryPath(MessageDigest sha1, ZipEntry zipEntry, boolean digestPaths) throws UnsupportedEncodingException {
        if (digestPaths) {
            sha1.update(zipEntry.getName().getBytes(Charsets.UTF_8));
        }
    }
}

